/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.dossier.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_184;
import net.minecraft.class_2062;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2444;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DossierRecipesProvider
implements class_2405,
Consumer<Consumer<Consumer<class_2444>>> {
    private Consumer<Consumer<class_2444>> onGenerate;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2403 generator;

    public DossierRecipesProvider(class_2403 generator) {
        this.generator = generator;
    }

    public void method_10319(class_2408 cache) {
        Path path = this.generator.method_10313();
        HashSet set = Sets.newHashSet();
        this.generate(provider -> {
            if (!set.add(provider.method_10417())) {
                throw new IllegalStateException("Duplicate recipe " + provider.method_10417());
            }
            this.saveRecipe(cache, provider.method_17799(), path.resolve("data/" + provider.method_10417().method_12836() + "/recipes/" + provider.method_10417().method_12832() + ".json"));
            JsonObject advancementJson = provider.method_10415();
            if (advancementJson != null) {
                this.saveRecipeAdvancement(cache, advancementJson, path.resolve("data/" + provider.method_10417().method_12836() + "/advancements/" + provider.method_10418().method_12832() + ".json"));
            }
        });
        this.saveRecipeAdvancement(cache, class_161.class_162.method_707().method_709("impossible", (class_184)new class_2062.class_2063()).method_698(), path.resolve("data/minecraft/advancements/recipes/root.json"));
    }

    private void saveRecipe(class_2408 cache, JsonObject jsonObject, Path path) {
        try {
            String json = GSON.toJson((JsonElement)jsonObject);
            String string2 = field_11280.hashUnencodedChars((CharSequence)json).toString();
            if (!Objects.equals(cache.method_10323(path), string2) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedWriter.write(json);
                }
            }
            cache.method_10325(path, string2);
        }
        catch (IOException var19) {
            LOGGER.error("Couldn't save recipe {}", (Object)path, (Object)var19);
        }
    }

    private void saveRecipeAdvancement(class_2408 dataCache, JsonObject jsonObject, Path path) {
        try {
            String json = GSON.toJson((JsonElement)jsonObject);
            String hash = field_11280.hashUnencodedChars((CharSequence)json).toString();
            if (!Objects.equals(dataCache.method_10323(path), hash) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(json);
                }
            }
            dataCache.method_10325(path, hash);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save recipe advancement {}", (Object)path, (Object)e);
        }
    }

    private void generate(Consumer<class_2444> consumer) {
        this.onGenerate.accept(consumer);
    }

    public String method_10321() {
        return "Dossier Recipes";
    }

    @Override
    public void accept(Consumer<Consumer<class_2444>> onGenerate) {
        this.onGenerate = onGenerate;
    }
}

