/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.campanion.ropebridge;

import com.terraformersmc.campanion.client.model.block.BridgePlanksBakedModel;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.QuadViewImpl;
import net.minecraft.class_1058;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_4587;

public class RopeBridgePlank {
    private final class_2338 from;
    private final class_2338 to;
    private final class_243 deltaPosition;
    private final float yAngle;
    private final float tiltAngle;
    private final float distToPrevious;
    private final float ropesSubtract;
    private final int ropeVariant;
    private final boolean flat;
    private final boolean master;
    private final boolean ropes;
    private final boolean stopper;
    private boolean broken;
    private Mesh mesh;
    private static Mesh emptyPlanksMesh;

    public RopeBridgePlank(class_2338 from, class_2338 to, class_243 deltaPosition, double yAngle, double tiltAngle, float distToPrevious, float ropesSubtract, int ropeVariant, boolean flat, boolean master, boolean ropes, boolean stopper) {
        this.from = from;
        this.to = to;
        this.deltaPosition = deltaPosition;
        this.yAngle = (float)yAngle;
        this.tiltAngle = (float)tiltAngle;
        this.distToPrevious = distToPrevious;
        this.ropesSubtract = ropesSubtract;
        this.ropeVariant = ropeVariant;
        this.flat = flat;
        this.master = master;
        this.ropes = ropes;
        this.stopper = stopper;
    }

    public class_243 getDeltaPosition() {
        return this.deltaPosition;
    }

    public double getyAngle() {
        return this.yAngle;
    }

    public double getTiltAngle() {
        return this.tiltAngle;
    }

    public boolean isMaster() {
        return this.master;
    }

    public boolean isStopper() {
        return this.stopper;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken() {
        this.broken = true;
    }

    public class_2338 getFrom() {
        return this.from;
    }

    public class_2338 getTo() {
        return this.to;
    }

    public static RopeBridgePlank deserialize(class_2487 tag) {
        RopeBridgePlank plank = new RopeBridgePlank(class_2338.method_10092((long)tag.method_10537("FromPos")), class_2338.method_10092((long)tag.method_10537("ToPos")), new class_243(tag.method_10574("DeltaPosX"), tag.method_10574("DeltaPosY"), tag.method_10574("DeltaPosZ")), tag.method_10583("YAng"), tag.method_10583("TiltAng"), tag.method_10583("DistToPrevious"), tag.method_10583("RopesSubtract"), tag.method_10571("RopeVariant"), tag.method_10577("Flat"), tag.method_10577("Master"), tag.method_10577("Ropes"), tag.method_10577("Stopper"));
        plank.broken = tag.method_10577("Broken");
        return plank;
    }

    public static class_2487 serialize(RopeBridgePlank plank) {
        class_2487 tag = new class_2487();
        tag.method_10544("FromPos", plank.from.method_10063());
        tag.method_10544("ToPos", plank.to.method_10063());
        tag.method_10549("DeltaPosX", plank.deltaPosition.field_1352);
        tag.method_10549("DeltaPosY", plank.deltaPosition.field_1351);
        tag.method_10549("DeltaPosZ", plank.deltaPosition.field_1350);
        tag.method_10548("YAng", plank.yAngle);
        tag.method_10548("TiltAng", plank.tiltAngle);
        tag.method_10548("DistToPrevious", plank.distToPrevious);
        tag.method_10548("RopesSubtract", plank.ropesSubtract);
        tag.method_10567("RopeVariant", (byte)plank.ropeVariant);
        tag.method_10556("Flat", plank.flat);
        tag.method_10556("Master", plank.master);
        tag.method_10556("Ropes", plank.ropes);
        tag.method_10556("Stopper", plank.stopper);
        tag.method_10556("Broken", plank.broken);
        return tag;
    }

    public Optional<Mesh> getOrGenerateMesh(boolean translucent) {
        if (!this.master) {
            return Optional.empty();
        }
        if (this.mesh != null) {
            return Optional.of(this.mesh);
        }
        Random random = new Random(this.ropeVariant);
        byte[] discarded = new byte[256];
        random.nextBytes(discarded);
        RenderMaterial material = RendererAccess.INSTANCE.getRenderer().materialFinder().blendMode(0, BlendMode.CUTOUT).find();
        MeshBuilder builder = IndigoRenderer.INSTANCE.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        class_4587 stack = new class_4587();
        stack.method_22903();
        stack.method_22904(this.deltaPosition.method_10216(), this.deltaPosition.method_10214(), this.deltaPosition.field_1350);
        stack.method_22907(class_1160.field_20705.method_23626(-this.yAngle));
        this.renderPlank(emitter, stack, material, random, translucent);
        this.drawRope(emitter, stack, material, random, translucent);
        stack.method_22909();
        this.mesh = builder.build();
        return Optional.of(this.mesh);
    }

    private void renderPlank(QuadEmitter emitter, class_4587 stack, RenderMaterial material, Random random, boolean translucent) {
        stack.method_22903();
        if (!this.flat) {
            stack.method_22907(class_1160.field_20707.method_23626(this.tiltAngle));
        }
        class_1058 sprite = BridgePlanksBakedModel.PLANKS[random.nextInt(2)].method_24148();
        double vStart = (double)random.nextInt(4) * 0.25;
        float minV = sprite.method_4570(vStart * 16.0);
        float maxV = sprite.method_4570((vStart + 0.25) * 16.0);
        float hl = 0.496875f;
        float hw = 0.125f;
        this.drawDoubleSided(emitter, material, (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, -hw, 0.0f, -hl, sprite.method_4577(), minV, 0.0f, m, 0.0f), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, -hw, 0.0f, hl, sprite.method_4594(), minV, 0.0f, m, 0.0f), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, hw, 0.0f, hl, sprite.method_4594(), maxV, 0.0f, m, 0.0f), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, hw, 0.0f, -hl, sprite.method_4577(), maxV, 0.0f, m, 0.0f));
        stack.method_22909();
    }

    private void drawRope(QuadEmitter emitter, class_4587 stack, RenderMaterial material, Random random, boolean translucent) {
        class_1058 rope = BridgePlanksBakedModel.ROPE.method_24148();
        for (int modifier : new int[]{-1, 1}) {
            if (this.ropes) {
                this.drawVerticalRope(emitter, stack, material, rope, random, translucent, modifier);
            }
            if (this.stopper) {
                RopeBridgePlank.drawStopper(emitter, stack, material, random, translucent, modifier);
            }
            this.drawBottomRopes(emitter, stack, material, rope, random, translucent, modifier);
            stack.method_22903();
            stack.method_22904(0.0, (double)(0.90625f - this.ropesSubtract), (double)modifier * 0.99375 / 2.0);
            if (this.ropes) {
                this.drawKnot(emitter, stack, material, rope, random, translucent);
            }
            stack.method_22907(class_1160.field_20707.method_23626(this.tiltAngle));
            this.drawConnectingRope(emitter, stack, material, rope, random, translucent, modifier);
            stack.method_22909();
        }
    }

    private void drawBottomRopes(QuadEmitter emitter, class_4587 stack, RenderMaterial material, class_1058 rope, Random random, boolean translucent, int modifier) {
        stack.method_22903();
        stack.method_22904(0.0, -0.025, (double)modifier * 0.371875);
        stack.method_22907(class_1160.field_20707.method_23626(this.tiltAngle));
        float ropeStart = random.nextFloat() * (16.0f - this.distToPrevious * 16.0f);
        float minU = rope.method_4580((double)ropeStart);
        float maxU = rope.method_4580((double)(ropeStart + 1.0f));
        float minV = rope.method_4570((double)ropeStart);
        float maxV = rope.method_4570((double)(ropeStart + this.distToPrevious * 16.0f));
        this.drawDoubleSided(emitter, material, (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, 0.0f, 0.0f, 0.0f, maxU, minV, 0.0f, -m * modifier, 0.0f), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, 0.0f, 0.0f, (float)(modifier * -1) / 16.0f, minU, minV, 0.0f, -m * modifier, 0.0f), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, this.distToPrevious, 0.0f, (float)(modifier * -1) / 16.0f, minU, maxV, 0.0f, -m * modifier, 0.0f), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, this.distToPrevious, 0.0f, 0.0f, maxU, maxV, 0.0f, -m * modifier, 0.0f));
        stack.method_22909();
    }

    private void drawConnectingRope(QuadEmitter emitter, class_4587 stack, RenderMaterial material, class_1058 rope, Random random, boolean translucent, int modifier) {
        float ropeStart = random.nextFloat() * (16.0f - this.distToPrevious * 16.0f);
        float ropeMinU = rope.method_4580((double)ropeStart);
        float ropeMaxU = rope.method_4580((double)(ropeStart + 1.0f));
        float ropeMinV = rope.method_4570((double)ropeStart);
        float ropeMaxV = rope.method_4570((double)(ropeStart + this.distToPrevious * 16.0f));
        if (this.distToPrevious != 0.0f) {
            this.drawDoubleSided(emitter, material, (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, 0.0f, -0.03125f, 0.0f, ropeMinU, ropeMinV, 0.0f, 0.0f, modifier * m), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, this.distToPrevious, -0.03125f, 0.0f, ropeMinU, ropeMaxV, 0.0f, 0.0f, modifier * m), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, this.distToPrevious, 0.03125f, 0.0f, ropeMaxU, ropeMaxV, 0.0f, 0.0f, modifier * m), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, 0.0f, 0.03125f, 0.0f, ropeMaxU, ropeMinV, 0.0f, 0.0f, modifier * m));
        }
    }

    private void drawVerticalRope(QuadEmitter emitter, class_4587 stack, RenderMaterial material, class_1058 rope, Random random, boolean translucent, int modifier) {
        float hl = 0.496875f;
        float mhl = (float)modifier * hl;
        float ropeUStart = random.nextInt(15);
        float ropeMinU = rope.method_4580((double)ropeUStart);
        float ropeMaxU = rope.method_4580((double)(ropeUStart + 1.0f));
        float ropeMinV = rope.method_4593();
        float ropeMaxV = rope.method_4570((double)(14.5f - this.ropesSubtract * 16.0f));
        this.drawDoubleSided(emitter, material, (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, -0.03125f, 0.90625f - this.ropesSubtract, mhl, ropeMinU, ropeMinV, 0.0f, 0.0f, m * modifier), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, -0.03125f, 0.0f, mhl, ropeMinU, ropeMaxV, 0.0f, 0.0f, m * modifier), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, 0.03125f, 0.0f, mhl, ropeMaxU, ropeMaxV, 0.0f, 0.0f, m * modifier), (v, m) -> RopeBridgePlank.add(emitter, v, stack, translucent, 0.03125f, 0.90625f - this.ropesSubtract, mhl, ropeMaxU, ropeMinV, 0.0f, 0.0f, m * modifier));
    }

    private void drawKnot(QuadEmitter emitter, class_4587 stack, RenderMaterial material, class_1058 rope, Random random, boolean translucent) {
        int ropeKnotUStart = random.nextInt(15);
        int ropeKnotVStart = random.nextInt(15);
        RopeBridgePlank.drawCube(emitter, material, (index, x, y, z, u, v, nx, ny, nz, dir) -> RopeBridgePlank.add(emitter, index, stack, translucent, (float)(x * 1) / 32.0f, (float)(y * 1) / 32.0f, (float)(z * 1) / 32.0f, rope.method_4580((double)((float)ropeKnotUStart + 1.0f * Math.signum((float)u + 1.0f))), rope.method_4570((double)((float)ropeKnotVStart + 1.0f * Math.signum((float)v + 1.0f))), nx, ny, nz));
    }

    public static void drawStopper(QuadEmitter emitter, class_4587 stack, RenderMaterial material, Random random, boolean translucent, int modifier) {
        stack.method_22903();
        stack.method_22904(0.0, 0.0, (double)modifier * 0.99375 / 2.0);
        float frameUStart = 4 + random.nextInt(8);
        RopeBridgePlank.drawCube(emitter, material, (index, x, y, z, u, v, nx, ny, nz, dir) -> {
            float texV;
            float texU;
            class_1058 sprite = BridgePlanksBakedModel.STOPPER.method_24148();
            if (dir.method_10166() == class_2350.class_2351.field_11052) {
                texU = sprite.method_4580((double)(u * 4));
                texV = sprite.method_4570((double)(16.0f - (float)(v * 4)));
            } else {
                texU = sprite.method_4580((double)(frameUStart + (float)(u * 4)));
                texV = sprite.method_4570((double)(16.0f - (float)(v * 16)));
            }
            RopeBridgePlank.add(emitter, index, stack, translucent, (float)(x * 4) / 32.0f, (float)(RopeBridgePlank.zo(y) * 16) / 16.0f, (float)(z * 4) / 32.0f, texU, texV, nx, ny, nz);
        });
        stack.method_22909();
    }

    private static void drawCube(QuadEmitter emitter, RenderMaterial material, CubeRenderCallback callback) {
        int[] vertex1 = new int[]{1, -1, -1, 1};
        int[] vertex2 = new int[]{-1, -1, 1, 1};
        for (class_2350 d : class_2350.values()) {
            int[] x = new int[4];
            int[] y = new int[4];
            int[] z = new int[4];
            switch (d.method_10166()) {
                case field_11048: {
                    Arrays.fill(x, d.method_10148());
                    y = vertex1;
                    z = vertex2;
                    break;
                }
                case field_11052: {
                    x = vertex1;
                    Arrays.fill(y, d.method_10164());
                    z = vertex2;
                    break;
                }
                case field_11051: {
                    x = vertex2;
                    y = vertex1;
                    Arrays.fill(z, d.method_10165());
                }
            }
            emitter.material(material);
            for (int v = 0; v < 4; ++v) {
                boolean flip = d.method_10171() == class_2350.class_2352.field_11056 != (d.method_10166() == class_2350.class_2351.field_11048);
                callback.apply(flip ? v : 3 - v, x[v], y[v], z[v], RopeBridgePlank.zo(vertex2[v]), RopeBridgePlank.zo(vertex1[v]), d.method_10148(), d.method_10164(), d.method_10165(), d);
            }
            emitter.emit();
        }
    }

    private static int zo(int i) {
        if (i < 0) {
            return 0;
        }
        return 1;
    }

    private void drawDoubleSided(QuadEmitter emitter, RenderMaterial material, VertexConsumer v1, VertexConsumer v2, VertexConsumer v3, VertexConsumer v4) {
        emitter.material(material);
        v1.apply(0, 1);
        v2.apply(1, 1);
        v3.apply(2, 1);
        v4.apply(3, 1);
        emitter.emit();
        emitter.material(material);
        v1.apply(3, -1);
        v2.apply(2, -1);
        v3.apply(1, -1);
        v4.apply(0, -1);
        emitter.emit();
    }

    private static void add(QuadEmitter emitter, int index, class_4587 stack, boolean translucent, float x, float y, float z, float u, float v, float nx, float ny, float nz) {
        class_1162 pos = new class_1162(x, y, z, 1.0f);
        pos.method_22674(stack.method_23760().method_23761());
        class_1160 normal = new class_1160(nx, ny, nz);
        normal.method_23215(stack.method_23760().method_23762());
        emitter.pos(index, pos.method_4953(), pos.method_4956(), pos.method_4957()).sprite(index, 0, u, v).spriteColor(index, 0, translucent ? -1996488705 : -1).cullFace(null).normal(index, normal);
        if (emitter instanceof QuadViewImpl) {
            ((QuadViewImpl)emitter).geometryFlags(((QuadViewImpl)emitter).geometryFlags() - 2);
        }
    }

    public static Mesh getEmptyPlanksMesh() {
        if (emptyPlanksMesh != null) {
            return emptyPlanksMesh;
        }
        RenderMaterial material = RendererAccess.INSTANCE.getRenderer().materialFinder().blendMode(0, BlendMode.CUTOUT).find();
        MeshBuilder builder = IndigoRenderer.INSTANCE.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        class_4587 stack = new class_4587();
        stack.method_22903();
        stack.method_22904(0.5, 0.0, 0.5);
        RopeBridgePlank.drawStopper(emitter, stack, material, new Random(0L), false, 1);
        RopeBridgePlank.drawStopper(emitter, stack, material, new Random(0L), false, -1);
        stack.method_22909();
        emptyPlanksMesh = builder.build();
        return emptyPlanksMesh;
    }

    @FunctionalInterface
    private static interface CubeRenderCallback {
        public void apply(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, class_2350 var10);
    }

    @FunctionalInterface
    private static interface VertexConsumer {
        public void apply(int var1, int var2);
    }
}

