/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.RewardsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OreSphereReward
extends BaseCustomReward {
    public OreSphereReward() {
        super("chancecubes:ore_sphere", 0);
    }

    @Override
    public void trigger(World world, BlockPos pos, EntityPlayer player, Map<String, Object> settings) {
        CustomEntry<Block, Integer> ore;
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        List<String> whiteList = Arrays.asList(super.getSettingAsStringList(settings, "white_list", new String[0]));
        if (whiteList.size() > 0) {
            ore = RewardsUtil.getRandomOreFromOreDict(whiteList.get(RewardsUtil.rand.nextInt(whiteList.size())));
        } else {
            List<String> blackList = Arrays.asList(super.getSettingAsStringList(settings, "black_list", new String[0]));
            ore = RewardsUtil.getRandomOre(blackList);
        }
        int delay = 0;
        for (int i = 0; i < 5; ++i) {
            for (int yy = -5; yy < 6; ++yy) {
                for (int zz = -5; zz < 6; ++zz) {
                    for (int xx = -5; xx < 6; ++xx) {
                        BlockPos loc = new BlockPos(xx, yy, zz);
                        double dist = Math.abs(loc.func_185332_f(0, 0, 0));
                        if (!(dist <= (double)i) || !(dist > (double)(i - 1))) continue;
                        OffsetBlock osb = new OffsetBlock(xx, yy, zz, ore.getKey(), false, delay);
                        osb.setBlockState(RewardsUtil.getBlockStateFromBlockMeta(ore.getKey(), ore.getValue()));
                        blocks.add(osb);
                        ++delay;
                    }
                }
            }
            delay += 10;
        }
        for (OffsetBlock b : blocks) {
            b.spawnInWorld(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }
}

