/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.util.RewardsUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RewardBlockCache {
    protected Map<BlockPos, IBlockState> storedBlocks = new HashMap<BlockPos, IBlockState>();
    protected Map<BlockPos, NBTTagCompound> storedTE = new HashMap<BlockPos, NBTTagCompound>();
    private BlockPos origin;
    private BlockPos playerloc;
    private World world;
    private boolean force = true;

    public RewardBlockCache(World world, BlockPos pos, BlockPos playerloc) {
        this.world = world;
        this.origin = pos;
        this.playerloc = playerloc;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void cacheBlock(BlockPos offset, IBlockState newState) {
        this.cacheBlock(offset, newState, 3);
    }

    public void cacheBlock(BlockPos offset, IBlockState newState, int update) {
        BlockPos adjPos = this.origin.func_177971_a((Vec3i)offset);
        IBlockState oldState = this.world.func_180495_p(adjPos);
        NBTTagCompound oldNBT = null;
        TileEntity te = this.world.func_175625_s(adjPos);
        if (te != null) {
            oldNBT = te.serializeNBT();
            if (te instanceof IInventory) {
                ((IInventory)te).func_174888_l();
            }
        }
        if (RewardsUtil.placeBlock(newState, this.world, adjPos, update, this.force) && !this.storedBlocks.containsKey(offset)) {
            this.storedBlocks.put(offset, oldState);
            if (oldNBT != null) {
                this.storedTE.put(offset, oldNBT);
            }
        }
    }

    public void restoreBlocks(Entity player) {
        for (BlockPos loc : this.storedBlocks.keySet()) {
            RewardsUtil.placeBlock(this.storedBlocks.get(loc), this.world, this.origin.func_177971_a((Vec3i)loc), true);
            if (!this.storedTE.containsKey(loc)) continue;
            this.world.func_175625_s(this.origin.func_177971_a((Vec3i)loc)).deserializeNBT(this.storedTE.get(loc));
        }
        if (player != null) {
            player.func_70634_a((double)this.playerloc.func_177958_n() + 0.5, (double)this.playerloc.func_177956_o(), (double)this.playerloc.func_177952_p() + 0.5);
        }
    }
}

