/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.config.ConfigLoader;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.OffsetTileEntity;
import chanceCubes.rewards.variableTypes.BoolVar;
import chanceCubes.rewards.variableTypes.FloatVar;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.rewards.variableTypes.NBTVar;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.CustomSchematic;
import chanceCubes.util.FileUtil;
import chanceCubes.util.RewardsUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SchematicUtil {
    private static Gson gson = new GsonBuilder().create();
    public static BlockPos[] selectionPoints = new BlockPos[2];

    public static void createCustomSchematic(World world, BlockPos loc1, BlockPos loc2, String fileName) {
        IBlockState blockState;
        ArrayList<Integer> blocks = new ArrayList<Integer>();
        ArrayList<CustomEntry<Integer, String>> blockDataIds = new ArrayList<CustomEntry<Integer, String>>();
        ArrayList tileEntityData = new ArrayList();
        int largeX = Math.max(loc1.func_177958_n(), loc2.func_177958_n());
        int smallX = Math.min(loc1.func_177958_n(), loc2.func_177958_n());
        int largeY = Math.max(loc1.func_177956_o(), loc2.func_177956_o());
        int smallY = Math.min(loc1.func_177956_o(), loc2.func_177956_o());
        int largeZ = Math.max(loc1.func_177952_p(), loc2.func_177952_p());
        int smallZ = Math.min(loc1.func_177952_p(), loc2.func_177952_p());
        StringBuilder blockData = new StringBuilder();
        for (int y = smallY; y < largeY; ++y) {
            for (int x = smallX; x < largeX; ++x) {
                for (int z = smallZ; z < largeZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    blockState = world.func_180495_p(pos);
                    blockData.append(blockState.func_177230_c().getRegistryName().toString());
                    blockData.setLength(0);
                    blockData.append(":");
                    blockData.append(blockState.func_177230_c().func_176201_c(blockState));
                    String blockString = blockData.toString();
                    int id = -1;
                    for (CustomEntry customEntry : blockDataIds) {
                        if (!blockString.equalsIgnoreCase((String)customEntry.getValue())) continue;
                        id = (Integer)customEntry.getKey();
                    }
                    if (id == -1) {
                        id = blockDataIds.size();
                        blockDataIds.add(new CustomEntry<Integer, String>(id, blockString));
                    }
                    blocks.add(id);
                    if (world.func_175625_s(pos) == null) continue;
                    TileEntity tileEntity = world.func_175625_s(pos);
                    NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                    nBTTagCompound2 = tileEntity.func_189515_b(nBTTagCompound2);
                    for (CustomEntry customEntry : tileEntityData) {
                        if (!nBTTagCompound2.toString().equalsIgnoreCase((String)customEntry.getKey())) continue;
                        ((List)customEntry.getValue()).add(blocks.size() - 1);
                        break;
                    }
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    list.add(blocks.size() - 1);
                    tileEntityData.add(new CustomEntry(nBTTagCompound2.toString(), list));
                }
            }
        }
        JsonObject json = new JsonObject();
        JsonArray blockArray = new JsonArray();
        int row = 0;
        int last = -1;
        blockState = blocks.iterator();
        while (blockState.hasNext()) {
            int i = (Integer)blockState.next();
            if (last == i) {
                ++row;
                continue;
            }
            if (row != 0) {
                String value = "" + last;
                if (row != 1) {
                    value = value + "x" + row;
                }
                blockArray.add((JsonElement)new JsonPrimitive(value));
            }
            last = i;
            row = 1;
        }
        String value = "" + last;
        if (row != 1) {
            value = value + "x" + row;
        }
        blockArray.add((JsonElement)new JsonPrimitive(value));
        json.add("Blocks", (JsonElement)blockArray);
        JsonArray blockDataArray = new JsonArray();
        for (CustomEntry customEntry : blockDataIds) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty((String)customEntry.getValue(), (Number)customEntry.getKey());
            blockDataArray.add((JsonElement)jsonObject);
        }
        json.add("Block Data", (JsonElement)blockDataArray);
        JsonArray tileEntityDataArray = new JsonArray();
        for (CustomEntry customEntry : tileEntityData) {
            JsonObject index = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            Iterator iterator = ((List)customEntry.getValue()).iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                jsonArray.add((JsonElement)new JsonPrimitive((Number)id));
            }
            index.add((String)customEntry.getKey(), (JsonElement)jsonArray);
            tileEntityDataArray.add((JsonElement)index);
        }
        json.add("TileEntities", (JsonElement)tileEntityDataArray);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("xSize", (Number)(largeX - smallX));
        jsonObject.addProperty("ySize", (Number)(largeY - smallY));
        jsonObject.addProperty("zSize", (Number)(largeZ - smallZ));
        json.add("Schematic Data", (JsonElement)jsonObject);
        FileUtil.writeToFile(ConfigLoader.folder.getAbsolutePath() + "/CustomRewards/Schematics/" + fileName, gson.toJson((JsonElement)json));
    }

    public static CustomSchematic loadLegacySchematic(String fileName, int xoff, int yoff, int zoff, FloatVar spacingDelay, BoolVar falling, BoolVar relativeToPlayer, BoolVar includeAirBlocks, BoolVar playSound, IntVar delay) {
        NBTTagCompound nbtdata;
        File schematic = new File(ConfigLoader.folder.getAbsolutePath() + "/CustomRewards/Schematics/" + fileName);
        try {
            FileInputStream is = new FileInputStream(schematic);
            nbtdata = CompressedStreamTools.func_74796_a((InputStream)is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return SchematicUtil.loadLegacySchematic(nbtdata, xoff, yoff, zoff, spacingDelay, falling, relativeToPlayer, includeAirBlocks, playSound, delay);
    }

    public static CustomSchematic loadLegacySchematic(NBTTagCompound nbtdata, int xoff, int yoff, int zoff, FloatVar spacingDelay, BoolVar falling, BoolVar relativeToPlayer, BoolVar includeAirBlocks, BoolVar playSound, IntVar delay) {
        int width = nbtdata.func_74765_d("Width");
        int height = nbtdata.func_74765_d("Height");
        int length = nbtdata.func_74765_d("Length");
        byte[] blocks = nbtdata.func_74770_j("Blocks");
        byte[] data = nbtdata.func_74770_j("Data");
        ArrayList<OffsetBlock> offsetBlocks = new ArrayList<OffsetBlock>();
        NBTTagList tileentities = nbtdata.func_150295_c("TileEntities", 10);
        int i = 0;
        short halfLength = (short)(length / 2);
        short halfWidth = (short)(width / 2);
        for (int yy = 0; yy < height; ++yy) {
            for (int zz = 0; zz < length; ++zz) {
                for (int xx = 0; xx < width; ++xx) {
                    Object b;
                    int j = blocks[i];
                    if (j < 0) {
                        j = 128 + (128 + j);
                    }
                    if ((b = Block.func_149729_e((int)j)) != Blocks.field_150350_a) {
                        OffsetBlock block = new OffsetBlock(halfWidth - xx, yy, halfLength - zz, (Block)b, falling);
                        block.setRelativeToPlayer(relativeToPlayer);
                        block.setBlockState(RewardsUtil.getBlockStateFromBlockMeta((Block)b, data[i]));
                        block.setPlaysSound(playSound);
                        offsetBlocks.add(block);
                    }
                    ++i;
                }
            }
        }
        for (int i1 = 0; i1 < tileentities.func_74745_c(); ++i1) {
            NBTTagCompound nbttagcompound4 = tileentities.func_150305_b(i1);
            TileEntity tileentity = TileEntity.func_190200_a(null, (NBTTagCompound)nbttagcompound4);
            if (tileentity == null) continue;
            Block b = null;
            for (OffsetBlock osb : offsetBlocks) {
                if (osb.xOff.getIntValue() != halfWidth - tileentity.func_174877_v().func_177958_n() || osb.yOff.getIntValue() != tileentity.func_174877_v().func_177956_o() || osb.zOff.getIntValue() != halfLength - tileentity.func_174877_v().func_177952_p()) continue;
                b = osb.getBlockState().func_177230_c();
            }
            if (b == null) {
                b = Blocks.field_150348_b;
            }
            OffsetTileEntity block = new OffsetTileEntity(halfWidth - tileentity.func_174877_v().func_177958_n(), tileentity.func_174877_v().func_177956_o(), halfLength - tileentity.func_174877_v().func_177952_p(), b.func_176223_P(), nbttagcompound4, falling);
            block.setRelativeToPlayer(relativeToPlayer);
            block.setBlockState(RewardsUtil.getBlockStateFromBlockMeta(b, data[i1]));
            block.setPlaysSound(playSound);
            offsetBlocks.add(block);
        }
        return new CustomSchematic(offsetBlocks, width, height, length, relativeToPlayer, includeAirBlocks, spacingDelay, delay);
    }

    public static CustomSchematic loadCustomSchematic(String file, int xOffSet, int yOffSet, int zOffSet, FloatVar spacingDelay, BoolVar falling, BoolVar relativeToPlayer, BoolVar includeAirBlocks, BoolVar playSound, IntVar delay) {
        JsonElement elem = FileUtil.readJsonfromFile(ConfigLoader.folder.getAbsolutePath() + "/CustomRewards/Schematics/" + file);
        return SchematicUtil.loadCustomSchematic(elem, xOffSet, yOffSet, zOffSet, spacingDelay, falling, relativeToPlayer, includeAirBlocks, playSound, delay);
    }

    public static CustomSchematic loadCustomSchematic(JsonElement elem, int xOffSet, int yOffSet, int zOffSet, FloatVar spacingDelay, BoolVar falling, BoolVar relativeToPlayer, BoolVar includeAirBlocks, BoolVar playSound, IntVar delay) {
        if (elem == null) {
            return null;
        }
        JsonObject json = elem.getAsJsonObject();
        ArrayList<OffsetBlock> offsetBlocks = new ArrayList<OffsetBlock>();
        JsonObject info = json.get("Schematic Data").getAsJsonObject();
        int xSize = info.get("xSize").getAsInt();
        int ySize = info.get("ySize").getAsInt();
        int zSize = info.get("zSize").getAsInt();
        ArrayList blockDataIds = new ArrayList();
        JsonArray blockDataArray = json.get("Block Data").getAsJsonArray();
        for (JsonElement i : blockDataArray) {
            JsonObject index = i.getAsJsonObject();
            for (Map.Entry obj : index.entrySet()) {
                blockDataIds.add(new CustomEntry(((JsonElement)obj.getValue()).getAsInt(), obj.getKey()));
            }
        }
        int index = 0;
        ArrayList<Integer> blockArray = new ArrayList<Integer>();
        for (JsonElement ids : json.get("Blocks").getAsJsonArray()) {
            String entry = ids.getAsString();
            String[] parts = entry.split("x");
            int id = Integer.parseInt(parts[0]);
            int recurse = parts.length > 1 ? Integer.parseInt(parts[1]) : 1;
            for (int i = 0; i < recurse; ++i) {
                blockArray.add(id);
            }
        }
        for (int yOff = 0; yOff < ySize; ++yOff) {
            for (int xOff = xSize / 2 - xSize; xOff < xSize / 2; ++xOff) {
                for (int zOff = zSize / 2 - zSize; zOff < zSize / 2; ++zOff) {
                    int id = (Integer)blockArray.get(index);
                    String blockData = "";
                    for (CustomEntry customEntry : blockDataIds) {
                        if ((Integer)customEntry.getKey() != id) continue;
                        blockData = (String)customEntry.getValue();
                        break;
                    }
                    String[] dataParts = blockData.split(":");
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(dataParts[0], dataParts[1]));
                    OffsetBlock osb = new OffsetBlock(xOff + xOffSet, yOff + yOffSet, zOff + zOffSet, block, falling, new IntVar(0));
                    osb.setBlockState(RewardsUtil.getBlockStateFromBlockMeta(block, Integer.parseInt(dataParts[2])));
                    osb.setRelativeToPlayer(relativeToPlayer);
                    osb.setPlaysSound(playSound);
                    offsetBlocks.add(osb);
                    ++index;
                }
            }
        }
        JsonArray teArray = json.get("TileEntities").getAsJsonArray();
        for (JsonElement i : teArray) {
            for (Map.Entry obj : i.getAsJsonObject().entrySet()) {
                String teData = (String)obj.getKey();
                for (JsonElement ids : ((JsonElement)obj.getValue()).getAsJsonArray()) {
                    int id = ids.getAsInt();
                    OffsetBlock osb = (OffsetBlock)offsetBlocks.get(id);
                    OffsetTileEntity oste = SchematicUtil.OffsetBlockToTileEntity(osb, teData);
                    if (oste == null) continue;
                    offsetBlocks.set(id, oste);
                }
            }
        }
        return new CustomSchematic(offsetBlocks, xSize, ySize, zSize, relativeToPlayer, includeAirBlocks, spacingDelay, delay);
    }

    public static OffsetTileEntity OffsetBlockToTileEntity(OffsetBlock osb, String nbt) {
        try {
            return SchematicUtil.OffsetBlockToTileEntity(osb, JsonToNBT.func_180713_a((String)nbt));
        }
        catch (NBTException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OffsetTileEntity OffsetBlockToTileEntity(OffsetBlock osb, NBTVar nbt) {
        OffsetTileEntity oste = new OffsetTileEntity(osb.xOff, osb.yOff, osb.zOff, osb.getBlockState(), nbt, osb.isFallingVar(), osb.getDelayVar());
        oste.setBlockState(osb.getBlockState());
        oste.setDelay(osb.getDelay());
        oste.setRelativeToPlayer(osb.isRelativeToPlayer());
        oste.setFalling(osb.isFalling());
        return oste;
    }

    public static OffsetTileEntity OffsetBlockToTileEntity(OffsetBlock osb, NBTTagCompound nbt) {
        OffsetTileEntity oste = new OffsetTileEntity(osb.xOff, osb.yOff, osb.zOff, osb.getBlockState(), new NBTVar(nbt), osb.isFallingVar(), osb.getDelayVar());
        oste.setBlockState(osb.getBlockState());
        oste.setDelay(osb.getDelay());
        oste.setRelativeToPlayer(osb.isRelativeToPlayer());
        oste.setFalling(osb.isFalling());
        return oste;
    }

    public static JsonElement getSchematicJson(String path) {
        BufferedReader in = new BufferedReader(new InputStreamReader(SchematicUtil.class.getResourceAsStream(path)));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return FileUtil.JSON_PARSER.parse(builder.toString());
    }
}

