/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.biodomeGen.BasicTreesBiome;
import chanceCubes.rewards.biodomeGen.DesertBiome;
import chanceCubes.rewards.biodomeGen.EndBiome;
import chanceCubes.rewards.biodomeGen.IBioDomeBiome;
import chanceCubes.rewards.biodomeGen.NetherBiome;
import chanceCubes.rewards.biodomeGen.OceanBiome;
import chanceCubes.rewards.biodomeGen.SnowGlobeBiome;
import chanceCubes.rewards.defaultRewards.IChanceCubeReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.Location3I;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class BioDomeReward
implements IChanceCubeReward {
    private Random rand = new Random();
    private IBioDomeBiome[] biomes = new IBioDomeBiome[]{new BasicTreesBiome(), new DesertBiome(), new EndBiome(), new OceanBiome(), new SnowGlobeBiome(), new NetherBiome()};
    public static final int delayShorten = 10;

    @Override
    public void trigger(World world, int x, int y, int z, EntityPlayer player) {
        IBioDomeBiome spawnedBiome = this.biomes[this.rand.nextInt(this.biomes.length)];
        this.genDome(x, y, z, world, spawnedBiome);
    }

    public void genDome(int centerX, int centerY, int centerZ, World world, IBioDomeBiome spawnedBiome) {
        this.genDomePart(0, -25, centerX, centerY, centerZ, world, spawnedBiome);
    }

    public void genDomePart(int yinc, int xinc, final int centerX, final int centerY, final int centerZ, final World world, final IBioDomeBiome spawnedBiome) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        int delay = 0;
        for (int z = -25; z <= 25; ++z) {
            Location3I loc = new Location3I(xinc, yinc, z);
            float dist = Math.abs(loc.length()) - 25.0f;
            if (!(dist < 1.0f)) continue;
            if (dist >= 0.0f) {
                blocks.add(new OffsetBlock(xinc, yinc, z, Blocks.field_150359_w, false, delay / 10));
                ++delay;
            } else if (yinc == 0) {
                blocks.add(new OffsetBlock(xinc, yinc, z, spawnedBiome.getFloorBlock(), false, delay / 10));
                ++delay;
            }
            spawnedBiome.getRandomGenBlock(dist, this.rand, xinc, yinc, z, blocks, delay);
        }
        final int nextXinc = xinc + 1 > 25 ? -25 : xinc + 1;
        int Yinctemp = yinc;
        if (nextXinc == -25) {
            int n = Yinctemp = Yinctemp + 1 > 25 ? -1 : Yinctemp + 1;
        }
        if (Yinctemp == -1) {
            Scheduler.scheduleTask(new Task("Entity_Delays", delay){

                @Override
                public void callback() {
                    spawnedBiome.spawnEntities(centerX, centerY, centerZ, world);
                }
            });
            return;
        }
        final int nextYinc = Yinctemp;
        for (OffsetBlock b : blocks) {
            b.spawnInWorld(world, centerX, centerY, centerZ);
        }
        Task task = new Task("BioDome Reward", delay / 10){

            @Override
            public void callback() {
                BioDomeReward.this.genDomePart(nextYinc, nextXinc, centerX, centerY, centerZ, world, spawnedBiome);
            }
        };
        Scheduler.scheduleTask(task);
    }

    @Override
    public int getChanceValue() {
        return 0;
    }

    @Override
    public String getName() {
        return "chancecubes:BioDome";
    }
}

