/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.tileentities.TileGiantCube;
import chanceCubes.util.Location3I;
import chanceCubes.util.RewardsUtil;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GiantCubeUtil {
    public static boolean checkMultiBlockForm(int xCoord, int yCoord, int zCoord, World world, boolean build) {
        Location3I bottomLeft = GiantCubeUtil.findBottomCorner(xCoord, yCoord, zCoord, world);
        int cx = bottomLeft.getX();
        int cy = bottomLeft.getY();
        int cz = bottomLeft.getZ();
        int i = 0;
        for (int x = cx; x < cx + 3; ++x) {
            for (int y = cy; y < cy + 3; ++y) {
                for (int z = cz; z < cz + 3; ++z) {
                    if (!world.func_147439_a(x, y, z).equals((Object)CCubesBlocks.chanceCube)) continue;
                    ++i;
                }
            }
        }
        if (build) {
            if (i > 26) {
                GiantCubeUtil.setupStructure(cx, cy, cz, world, true);
                return true;
            }
            return false;
        }
        return i > 26;
    }

    public static void setupStructure(int xCoord, int yCoord, int zCoord, World world, boolean areCoordsCorrect) {
        int cx = xCoord;
        int cy = yCoord;
        int cz = zCoord;
        if (!areCoordsCorrect) {
            Location3I bottomLeft = GiantCubeUtil.findBottomCorner(xCoord, yCoord, zCoord, world);
            cx = bottomLeft.getX();
            cy = bottomLeft.getY();
            cz = bottomLeft.getZ();
        }
        int i = 0;
        for (int x = cx; x < cx + 3; ++x) {
            for (int z = cz; z < cz + 3; ++z) {
                for (int y = cy; y < cy + 3; ++y) {
                    boolean master;
                    RewardsUtil.placeBlock(CCubesBlocks.chanceGiantCube, world, x, y, z, 0, ++i == 27 ? 3 : 2);
                    TileEntity tile = world.func_147438_o(x, y, z);
                    boolean bl = master = x == cx && y == cy + 1 && z == cz;
                    if (tile == null || !(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).setMasterCoords(cx + 1, cy + 1, cz + 1);
                    ((TileGiantCube)tile).setHasMaster(true);
                    ((TileGiantCube)tile).setIsMaster(master);
                }
            }
        }
        world.func_72908_a((double)xCoord, (double)yCoord, (double)zCoord, "chancecubes:giant_Cube_Spawn", 1.0f, 1.0f);
    }

    public static Location3I findBottomCorner(int xCoord, int yCoord, int zCoord, World world) {
        int cx = xCoord;
        int cy = yCoord;
        int cz = zCoord;
        while (world.func_147439_a(cx, cy - 1, cz).equals((Object)CCubesBlocks.chanceCube)) {
            --cy;
        }
        while (world.func_147439_a(cx - 1, cy, cz).equals((Object)CCubesBlocks.chanceCube)) {
            --cx;
        }
        while (world.func_147439_a(cx, cy, cz - 1).equals((Object)CCubesBlocks.chanceCube)) {
            --cz;
        }
        return new Location3I(cx, cy, cz);
    }

    public static void resetStructure(int xCoord, int yCoord, int zCoord, World world) {
        for (int x = xCoord - 1; x < xCoord + 2; ++x) {
            for (int y = yCoord - 1; y < yCoord + 2; ++y) {
                for (int z = zCoord - 1; z < zCoord + 2; ++z) {
                    TileEntity tile = world.func_147438_o(x, y, z);
                    if (tile == null || !(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).reset();
                    world.func_147475_p(x, y, z);
                    world.func_147449_b(x, y, z, (Block)CCubesBlocks.chanceCube);
                }
            }
        }
    }

    public static void removeStructure(int xCoord, int yCoord, int zCoord, World world) {
        for (int x = xCoord - 1; x < xCoord + 2; ++x) {
            for (int y = yCoord - 1; y < yCoord + 2; ++y) {
                for (int z = zCoord - 1; z < zCoord + 2; ++z) {
                    TileEntity tile = world.func_147438_o(x, y, z);
                    if (tile == null || !(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).reset();
                    world.func_147475_p(x, y, z);
                    world.func_147468_f(x, y, z);
                }
            }
        }
    }
}

