/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.config.ConfigLoader;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.OffsetTileEntity;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.CustomSchematic;
import chanceCubes.util.FileUtil;
import chanceCubes.util.Location3I;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class SchematicUtil {
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static Location3I[] selectionPoints = new Location3I[2];

    public static void createCustomSchematic(World world, Location3I loc1, Location3I loc2, String fileName) {
        ArrayList<Integer> blocks = new ArrayList<Integer>();
        ArrayList<CustomEntry<Integer, String>> blockDataIds = new ArrayList<CustomEntry<Integer, String>>();
        ArrayList tileEntityData = new ArrayList();
        int largeX = loc1.getX() > loc2.getX() ? loc1.getX() : loc2.getX();
        int smallX = loc1.getX() < loc2.getX() ? loc1.getX() : loc2.getX();
        int largeY = loc1.getY() > loc2.getY() ? loc1.getY() : loc2.getY();
        int smallY = loc1.getY() < loc2.getY() ? loc1.getY() : loc2.getY();
        int largeZ = loc1.getZ() > loc2.getZ() ? loc1.getZ() : loc2.getZ();
        int smallZ = loc1.getZ() < loc2.getZ() ? loc1.getZ() : loc2.getZ();
        for (int y = smallY; y < largeY; ++y) {
            for (int x = smallX; x < largeX; ++x) {
                for (int z = smallZ; z < largeZ; ++z) {
                    Block b = world.func_147439_a(x, y, z);
                    String string2 = GameData.getBlockRegistry().func_148750_c((Object)b);
                    string2 = string2 + ":" + world.func_72805_g(x, y, z);
                    int n = -1;
                    for (CustomEntry customEntry : blockDataIds) {
                        if (!string2.equalsIgnoreCase((String)customEntry.getValue())) continue;
                        n = (Integer)customEntry.getKey();
                    }
                    if (n == -1) {
                        n = blockDataIds.size();
                        blockDataIds.add(new CustomEntry<Integer, String>(n, string2));
                    }
                    blocks.add(n);
                    if (world.func_147438_o(x, y, z) == null) continue;
                    TileEntity te = world.func_147438_o(x, y, z);
                    NBTTagCompound nBTTagCompound = new NBTTagCompound();
                    te.func_145841_b(nBTTagCompound);
                    for (CustomEntry customEntry : tileEntityData) {
                        if (!nBTTagCompound.toString().equalsIgnoreCase((String)customEntry.getKey())) continue;
                        ((List)customEntry.getValue()).add(blocks.size() - 1);
                        break;
                    }
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    list.add(blocks.size() - 1);
                    tileEntityData.add(new CustomEntry(nBTTagCompound.toString(), list));
                }
            }
        }
        JsonObject json = new JsonObject();
        JsonArray blockArray = new JsonArray();
        Iterator z = blocks.iterator();
        while (z.hasNext()) {
            int i = (Integer)z.next();
            blockArray.add((JsonElement)new JsonPrimitive((Number)i));
        }
        json.add("Blocks", (JsonElement)blockArray);
        JsonArray blockDataArray = new JsonArray();
        for (CustomEntry customEntry : blockDataIds) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty((String)customEntry.getValue(), (Number)customEntry.getKey());
            blockDataArray.add((JsonElement)jsonObject);
        }
        json.add("Block Data", (JsonElement)blockDataArray);
        JsonArray tileEntityDataArray = new JsonArray();
        for (CustomEntry customEntry : tileEntityData) {
            JsonObject index = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            Iterator iterator = ((List)customEntry.getValue()).iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                jsonArray.add((JsonElement)new JsonPrimitive((Number)n));
            }
            index.add((String)customEntry.getKey(), (JsonElement)jsonArray);
            tileEntityDataArray.add((JsonElement)index);
        }
        json.add("TileEntities", (JsonElement)tileEntityDataArray);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("xSize", (Number)(largeX - smallX));
        jsonObject.addProperty("ySize", (Number)(largeY - smallY));
        jsonObject.addProperty("zSize", (Number)(largeZ - smallZ));
        json.add("Schematic Data", (JsonElement)jsonObject);
        FileUtil.writeToFile(ConfigLoader.folder.getAbsolutePath() + "/CustomRewards/Schematics/" + fileName, gson.toJson((JsonElement)json));
    }

    public static CustomSchematic loadCustomSchematic(String file, int xOffSet, int yOffSet, int zOffSet, float delay, boolean falling, boolean relativeToPlayer) {
        JsonElement elem = FileUtil.readJsonfromFile(ConfigLoader.folder.getAbsolutePath() + "/CustomRewards/Schematics/" + file);
        if (elem == null) {
            return null;
        }
        JsonObject json = elem.getAsJsonObject();
        ArrayList<OffsetBlock> offsetBlocks = new ArrayList<OffsetBlock>();
        JsonObject info = json.get("Schematic Data").getAsJsonObject();
        int xSize = info.get("xSize").getAsInt();
        int ySize = info.get("ySize").getAsInt();
        int zSize = info.get("zSize").getAsInt();
        ArrayList blockDataIds = new ArrayList();
        JsonArray blockDataArray = json.get("Block Data").getAsJsonArray();
        for (JsonElement i : blockDataArray) {
            JsonObject index = i.getAsJsonObject();
            for (Map.Entry obj : index.entrySet()) {
                blockDataIds.add(new CustomEntry(((JsonElement)obj.getValue()).getAsInt(), obj.getKey()));
            }
        }
        float delayTotal = 0.0f;
        int index = 0;
        JsonArray blockArray = json.get("Blocks").getAsJsonArray();
        for (int yOff = 0; yOff < ySize; ++yOff) {
            for (int xOff = xSize / 2 - xSize; xOff < xSize / 2; ++xOff) {
                for (int zOff = zSize / 2 - zSize; zOff < zSize / 2; ++zOff) {
                    JsonElement element = blockArray.get(index);
                    int id = element.getAsInt();
                    String blockData = "";
                    for (CustomEntry customEntry : blockDataIds) {
                        if ((Integer)customEntry.getKey() != id) continue;
                        blockData = (String)customEntry.getValue();
                        break;
                    }
                    String[] dataParts = blockData.split(":");
                    Block block = GameRegistry.findBlock((String)dataParts[0], (String)dataParts[1]);
                    OffsetBlock osb = new OffsetBlock(xOff + xOffSet, yOff + yOffSet, zOff + zOffSet, block, falling, (int)delayTotal);
                    osb.setData(Byte.parseByte(dataParts[2]));
                    offsetBlocks.add(osb);
                    if (!block.equals(Blocks.field_150350_a)) {
                        delayTotal += delay;
                    }
                    ++index;
                }
            }
        }
        JsonArray teArray = json.get("TileEntities").getAsJsonArray();
        for (JsonElement i : teArray) {
            for (Map.Entry obj : i.getAsJsonObject().entrySet()) {
                String teData = (String)obj.getKey();
                for (JsonElement jsonElement : ((JsonElement)obj.getValue()).getAsJsonArray()) {
                    int id = jsonElement.getAsInt();
                    OffsetBlock osb = (OffsetBlock)offsetBlocks.get(id);
                    OffsetTileEntity oste = SchematicUtil.OffsetBlockToTileEntity(osb, teData);
                    if (oste == null) continue;
                    offsetBlocks.set(id, oste);
                }
            }
        }
        for (int i = offsetBlocks.size() - 1; i >= 0; --i) {
            OffsetBlock osb = (OffsetBlock)offsetBlocks.get(i);
            if (!osb.getBlock().equals(Blocks.field_150350_a)) continue;
            offsetBlocks.remove(i);
        }
        return new CustomSchematic(offsetBlocks, xSize, ySize, zSize, relativeToPlayer);
    }

    public static OffsetTileEntity OffsetBlockToTileEntity(OffsetBlock osb, String nbt) {
        try {
            return SchematicUtil.OffsetBlockToTileEntity(osb, (NBTTagCompound)JsonToNBT.func_150315_a((String)nbt));
        }
        catch (NBTException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OffsetTileEntity OffsetBlockToTileEntity(OffsetBlock osb, NBTTagCompound nbt) {
        OffsetTileEntity oste = new OffsetTileEntity(osb.xOff, osb.yOff, osb.zOff, osb.getBlock(), nbt, osb.isFalling(), osb.getDelay());
        oste.setData(osb.getData());
        oste.setDelay(osb.getDelay());
        oste.setRelativeToPlayer(osb.isRelativeToPlayer());
        oste.seFalling(osb.isFalling());
        return oste;
    }
}

