/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.concreteconversion.event.handlers;

import java.util.ArrayList;
import java.util.List;
import mrp_v2.concreteconversion.ConcreteConversion;
import mrp_v2.concreteconversion.config.ConfigOptions;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class ConcretePowderConverter {
    static List<EntityItem> entities = new ArrayList<EntityItem>();
    static List<EntityItem> removes = new ArrayList<EntityItem>();
    static long lastCheck = System.currentTimeMillis();

    @SubscribeEvent
    public static void itemTossEvent(ItemTossEvent event) {
        if (!ConcreteConversion.isClient && ConfigOptions.onlyPlayerThrownItems && ConcretePowderConverter.isConcretePowder(event.getEntityItem().func_92059_d())) {
            entities.add(event.getEntityItem());
        }
    }

    @SubscribeEvent
    public static void itemPickedUp(PlayerEvent.ItemPickupEvent event) {
        if (entities.contains(event.getOriginalEntity())) {
            removes.add(event.getOriginalEntity());
        }
    }

    @SubscribeEvent
    public static void itemExpired(ItemExpireEvent event) {
        if (entities.contains(event.getEntityItem())) {
            removes.add(event.getEntityItem());
        }
    }

    @SubscribeEvent
    public static void itemChecker(TickEvent.ServerTickEvent event) {
        if (!ConcreteConversion.isClient && (double)lastCheck + ConfigOptions.conversionCheckDelay < (double)System.currentTimeMillis()) {
            lastCheck = System.currentTimeMillis();
            if (!ConfigOptions.onlyPlayerThrownItems) {
                WorldServer[] worlds = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c;
                entities = new ArrayList<EntityItem>();
                for (WorldServer w : worlds) {
                    for (Entity e : w.field_72996_f) {
                        try {
                            entities.add((EntityItem)e);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            for (EntityItem e : entities) {
                if (!e.func_70090_H()) continue;
                ConcretePowderConverter.tryConvertEntity(e);
                removes.add(e);
            }
            entities.removeAll(removes);
            removes = new ArrayList<EntityItem>();
        }
    }

    public static boolean tryConvertEntity(EntityItem itemEntity) {
        ItemStack item = itemEntity.func_92059_d();
        if (ConcretePowderConverter.isConcretePowder(item)) {
            itemEntity.func_92058_a(ConcretePowderConverter.tryConvertStack(item));
            return true;
        }
        return false;
    }

    public static ItemStack tryConvertStack(ItemStack stack) {
        if (ConcretePowderConverter.isConcretePowder(stack)) {
            stack = new ItemStack(Blocks.field_192443_dR, stack.func_190916_E(), stack.func_77960_j());
        }
        return stack;
    }

    public static boolean isConcretePowder(ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_192444_dS;
    }
}

