/*
 * Decompiled with CFR 0.152.
 */
package com.mrp_v2.concreteconversion.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigOptions {
    public static ForgeConfigSpec.BooleanValue onlyPlayerThrownItems;
    public static ForgeConfigSpec.IntValue conversionCheckDelay;
    public static ForgeConfigSpec.IntValue conversionDelay;
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            onlyPlayerThrownItems = builder.comment("If true, only items thrown by the player will be converted into concrete.If false, all concrete powder items will be converted, including items dispensed by droppers, items that drop when a chest is destroyed, etc.").translation("mrp_v2.concreteconversion.configgui.onlyPlayerThrownItems").define("onlyPlayerThrownItems", true);
            conversionCheckDelay = builder.comment("Every this many game ticks, the mod will check wether the currently tracked concrete powder items are in water, and if they are, will convert them. The default is 20 ticks, or 1 second.").translation("mrp_v2.concreteconversion.configgui.conversionCheckDelay").defineInRange("conversionCheckDelay", 20, 1, 200);
            conversionDelay = builder.comment("After this many game ticks spent in water, the item will be converted.").translation("mrp_v2.concreteconversion.configgui.conversionDelay").defineInRange("conversionDelay", 0, 0, 6000);
            builder.pop();
        }
    }
}

