/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.woodcutter.inventory.WoodcutterContainer;
import ovh.corail.woodcutter.recipe.WoodcuttingRecipe;

@OnlyIn(value=Dist.CLIENT)
public class WoodcutterScreen
extends ContainerScreen<WoodcutterContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("textures/gui/container/stonecutter.png");
    private float sliderProgress;
    private boolean isSliderClicked;
    private int recipeIndexOffset;
    private boolean hasInput;

    public WoodcutterScreen(WoodcutterContainer containerIn, PlayerInventory playerInv, ITextComponent title) {
        super((Container)containerIn, playerInv, title);
        containerIn.setInventoryUpdateListener(this::func_214145_d);
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (!(type != ClickType.PICKUP || slotId != 0 || mouseButton != 0 || slotIn == null || slotIn.field_75222_d != 0 || this.field_213127_e.func_70445_o().func_190926_b() || slotIn.func_75211_c().func_190926_b() || Container.func_195929_a((ItemStack)this.field_213127_e.func_70445_o(), (ItemStack)slotIn.func_75211_c()))) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
        super.func_184098_a(slotIn, slotId, mouseButton, type);
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        super.render(mouseX, mouseY, partialTick);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 4.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = (int)(41.0f * this.sliderProgress);
        this.blit(i + 119, j + 15 + k, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int l = this.field_147003_i + 52;
        int i1 = this.field_147009_r + 14;
        int j1 = this.recipeIndexOffset + 12;
        this.func_214141_a(mouseX, mouseY, l, i1, j1);
        this.func_214142_b(l, i1, j1);
    }

    private void func_214141_a(int mouseX, int mouseY, int p_214141_3_, int p_214141_4_, int p_214141_5_) {
        for (int i = this.recipeIndexOffset; i < p_214141_5_ && i < ((WoodcutterContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = p_214141_3_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_214141_4_ + l * 18 + 2;
            int j1 = this.field_147000_g;
            if (i == ((WoodcutterContainer)this.field_147002_h).func_217073_e()) {
                j1 += 18;
            } else if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                j1 += 36;
            }
            this.blit(k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void func_214142_b(int p_214142_1_, int p_214142_2_, int p_214142_3_) {
        RenderHelper.func_74520_c();
        List<WoodcuttingRecipe> list = ((WoodcutterContainer)this.field_147002_h).getRecipeList();
        for (int i = this.recipeIndexOffset; i < p_214142_3_ && i < ((WoodcutterContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = p_214142_1_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_214142_2_ + l * 18 + 2;
            this.minecraft.func_175599_af().func_180450_b(list.get(i).func_77571_b(), k, i1);
        }
        RenderHelper.func_74518_a();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int buttonId) {
        this.isSliderClicked = false;
        if (this.hasInput) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((WoodcutterContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.getMinecraft().field_71439_g, l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
                this.getMinecraft().field_71442_b.func_78756_a(((WoodcutterContainer)this.field_147002_h).field_75152_c, l);
                return true;
            }
            i = this.field_147003_i + 119;
            j = this.field_147009_r + 14;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.isSliderClicked = true;
                this.sliderProgress = MathHelper.func_76131_a((float)((float)(mouseY - (double)j - 7.5) / 40.0f), (float)0.0f, (float)1.0f);
                this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            }
        }
        return super.mouseClicked(mouseX, mouseY, buttonId);
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.isSliderClicked && this.canScroll()) {
            int i = this.field_147009_r + 14;
            int j = i + 54;
            this.sliderProgress = ((float)p_mouseDragged_3_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - p_mouseScrolled_5_ / (double)i);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasInput && ((WoodcutterContainer)this.field_147002_h).getRecipeListSize() > 12;
    }

    private int getHiddenRows() {
        return (((WoodcutterContainer)this.field_147002_h).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void func_214145_d() {
        this.hasInput = ((WoodcutterContainer)this.field_147002_h).func_217083_h();
        if (!this.hasInput) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

