/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.registry;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.woodcutter.block.WoodcutterBlock;
import ovh.corail.woodcutter.compatibility.SupportMods;
import ovh.corail.woodcutter.registry.ModTabs;

@Mod.EventBusSubscriber(modid="corail_woodcutter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks {
    public static final Set<Block> WOODCUTTERS = new HashSet<Block>();
    private static final Random RANDOM = new Random();
    private static ItemStack RANDOM_STACK = ItemStack.field_190927_a;

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        for (WoodcutterVariant woodcutterVariant : WoodcutterVariant.values()) {
            ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), woodcutterVariant.name().toLowerCase());
        }
        if (SupportMods.BIOMESOPLENTY.isLoaded()) {
            for (Enum enum_ : WoodcutterBOPVariant.values()) {
                ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), enum_.name().toLowerCase());
            }
        }
        if (SupportMods.MIDNIGHT.isLoaded()) {
            for (Enum enum_ : WoodcutterMidnightVariant.values()) {
                ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), enum_.name().toLowerCase());
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterBlockItems(RegistryEvent.Register<Item> event) {
        WOODCUTTERS.forEach(woodcutterBlock -> event.getRegistry().register(new BlockItem(woodcutterBlock, new Item.Properties().func_200916_a(ModTabs.mainTab)).setRegistryName(woodcutterBlock.getRegistryName())));
    }

    public static void registerWoodcutter(IForgeRegistry<Block> registry, String name) {
        Block woodcutter = (Block)new WoodcutterBlock().setRegistryName("corail_woodcutter", name + "_woodcutter");
        registry.register((IForgeRegistryEntry)woodcutter);
        WOODCUTTERS.add(woodcutter);
    }

    public static ItemStack createRandomStack() {
        if (RANDOM_STACK.func_190926_b()) {
            RANDOM_STACK = new ItemStack((IItemProvider)WOODCUTTERS.stream().skip(RANDOM.nextInt(WOODCUTTERS.size())).findFirst().orElse(Blocks.field_222430_lS));
        }
        return RANDOM_STACK;
    }

    static enum WoodcutterMidnightVariant {
        BOGSHROOM,
        DARK_WILLOW,
        DEAD_WOOD,
        DEWSHROOM,
        NIGHTSHROOM,
        SHADOWROOT,
        VIRIDSHROOM;

    }

    static enum WoodcutterBOPVariant {
        CHERRY,
        DEAD,
        ETHEREAL,
        FIR,
        HELLBARK,
        JACARANDA,
        MAGIC,
        MAHOGANY,
        PALM,
        REDWOOD,
        UMBRAN,
        WILLOW;

    }

    static enum WoodcutterVariant {
        OAK,
        BIRCH,
        SPRUCE,
        JUNGLE,
        ACACIA,
        DARK_OAK;

    }
}

