/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.woodcutter.recipe.WoodcuttingRecipe;
import ovh.corail.woodcutter.registry.ModBlocks;
import ovh.corail.woodcutter.registry.ModContainers;
import ovh.corail.woodcutter.registry.ModRecipeTypes;

public class WoodcutterContainer
extends Container {
    private final IWorldPosCallable iWorldPosCallable;
    private final IntReferenceHolder selectedRecipe = IntReferenceHolder.func_221492_a();
    private final World world;
    private List<WoodcuttingRecipe> recipes = new ArrayList<WoodcuttingRecipe>();
    private ItemStack result = ItemStack.field_190927_a;
    private long lastTakeTime;
    private final Slot inputSlot;
    private final Slot outputSlot;
    private Runnable inventoryUpdateListener = () -> {};
    private final IInventory inventory = new Inventory(1){

        public void func_70296_d() {
            super.func_70296_d();
            WoodcutterContainer.this.func_75130_a((IInventory)this);
            WoodcutterContainer.this.inventoryUpdateListener.run();
        }
    };
    private final CraftResultInventory resultInventory = new CraftResultInventory();

    public WoodcutterContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public WoodcutterContainer(int id, PlayerInventory playerInventory, final IWorldPosCallable iWorldPosCallable) {
        super(ModContainers.WOODCUTTER, id);
        this.iWorldPosCallable = iWorldPosCallable;
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.inputSlot = this.func_75146_a(new Slot(this.inventory, 0, 20, 33));
        this.outputSlot = this.func_75146_a(new Slot((IInventory)this.resultInventory, 1, 143, 33){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                ItemStack itemstack = WoodcutterContainer.this.inputSlot.func_75209_a(1);
                if (!itemstack.func_190926_b()) {
                    WoodcutterContainer.this.func_217082_i();
                }
                stack.func_77973_b().func_77622_d(stack, thePlayer.field_70170_p, thePlayer);
                iWorldPosCallable.func_221486_a((world, pos) -> {
                    long l = world.func_82737_E();
                    if (WoodcutterContainer.this.lastTakeTime != l) {
                        world.func_184133_a(null, pos, SoundEvents.field_219719_ml, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        WoodcutterContainer.this.lastTakeTime = l;
                    }
                });
                return super.func_190901_a(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 142));
        }
        this.func_216958_a(this.selectedRecipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_217073_e() {
        return this.selectedRecipe.func_221495_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<WoodcuttingRecipe> getRecipeList() {
        return this.recipes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRecipeListSize() {
        return this.recipes.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_217083_h() {
        return this.inputSlot.func_75216_d() && !this.recipes.isEmpty();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return (Boolean)this.iWorldPosCallable.func_221485_a((world, pos) -> ModBlocks.WOODCUTTERS.contains(world.func_180495_p(pos).func_177230_c()) && playerIn.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0, (Object)true);
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if (id >= 0 && id < this.recipes.size()) {
            this.selectedRecipe.func_221494_a(id);
            this.func_217082_i();
        }
        return true;
    }

    public void func_75130_a(IInventory inventoryIn) {
        ItemStack stack = this.inputSlot.func_75211_c();
        if (stack.func_77973_b() != this.result.func_77973_b()) {
            this.result = stack.func_77946_l();
            this.updateAvailableRecipes(inventoryIn, stack);
        }
    }

    private void updateAvailableRecipes(IInventory inventoryIn, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.func_221494_a(-1);
        this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            this.recipes = this.world.func_199532_z().func_215370_b(ModRecipeTypes.WOODCUTTING, inventoryIn, this.world);
        }
    }

    private void func_217082_i() {
        if (!this.recipes.isEmpty()) {
            WoodcuttingRecipe recipe = this.recipes.get(this.selectedRecipe.func_221495_b());
            this.outputSlot.func_75215_d(recipe.func_77572_b(this.inventory));
        } else {
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public ContainerType<?> func_216957_a() {
        return ModContainers.WOODCUTTER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable runnable) {
        this.inventoryUpdateListener = runnable;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.inventory && super.func_94530_a(stack, slotIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            Item item = itemstack1.func_77973_b();
            stack = itemstack1.func_77946_l();
            if (index == 1) {
                item.func_77622_d(itemstack1, playerIn.field_70170_p, playerIn);
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, stack);
            } else if (index == 0 ? !this.func_75135_a(itemstack1, 2, 38, false) : (this.world.func_199532_z().func_215371_a(ModRecipeTypes.WOODCUTTING, (IInventory)new Inventory(new ItemStack[]{itemstack1}), this.world).isPresent() ? !this.func_75135_a(itemstack1, 0, 1, false) : (index < 29 ? !this.func_75135_a(itemstack1, 29, 38, false) : index < 38 && !this.func_75135_a(itemstack1, 2, 29, false)))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (itemstack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
            this.func_75142_b();
        }
        return stack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.resultInventory.func_70304_b(1);
        this.iWorldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(playerIn, (World)world, this.inventory));
    }
}

