/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.CuriosRegistry;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;
import top.theillusivec4.curios.client.EventHandlerClient;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.client.gui.GuiContainerCurios;
import top.theillusivec4.curios.client.gui.GuiEventHandler;
import top.theillusivec4.curios.client.render.LayerCurios;
import top.theillusivec4.curios.common.CommandCurios;
import top.theillusivec4.curios.common.CuriosConfig;
import top.theillusivec4.curios.common.capability.CapCurioInventory;
import top.theillusivec4.curios.common.capability.CapCurioItem;
import top.theillusivec4.curios.common.event.EventHandlerCurios;
import top.theillusivec4.curios.common.inventory.ContainerCurios;
import top.theillusivec4.curios.common.inventory.CurioContainerHandler;
import top.theillusivec4.curios.common.network.NetworkHandler;

@Mod(value="curios")
public class Curios {
    public static final String MODID = "curios";
    private static final boolean DEBUG = false;

    public Curios() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueue);
        eventBus.addListener(this::process);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CuriosConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CuriosConfig.clientSpec);
    }

    private void setup(FMLCommonSetupEvent evt) {
        CapCurioInventory.register();
        CapCurioItem.register();
        NetworkHandler.register();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCurios());
    }

    private void enqueue(InterModEnqueueEvent evt) {
        for (String id : (List)CuriosConfig.COMMON.createCurios.get()) {
            Curios.send("register_type", new CurioIMCMessage(id));
        }
        for (String id : (List)CuriosConfig.COMMON.disabledCurios.get()) {
            Curios.send("modify_type", new CurioIMCMessage(id).setEnabled(false));
        }
    }

    private void process(InterModProcessEvent evt) {
        CuriosRegistry.processCurioTypes(evt.getIMCStream("register_type"::equals), evt.getIMCStream("modify_type"::equals));
    }

    private static void send(String id, Object msg) {
        InterModComms.sendTo((String)MODID, (String)id, () -> msg);
    }

    private void onServerStarting(FMLServerStartingEvent evt) {
        CommandCurios.register((CommandDispatcher<CommandSource>)evt.getCommandDispatcher());
    }

    @Mod.EventBusSubscriber(modid="curios", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientProxy {
        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent evt) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
            MinecraftForge.EVENT_BUS.register((Object)new GuiEventHandler());
            MinecraftForge.EVENT_BUS.addListener(ClientProxy::onTextureStitch);
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.GUIFACTORY, () -> ClientProxy::getGuiContainer);
            KeyRegistry.registerKeys();
            CuriosAPI.registerIcon("ring", new ResourceLocation(Curios.MODID, "item/empty_ring_slot"));
            CuriosAPI.registerIcon("necklace", new ResourceLocation(Curios.MODID, "item/empty_necklace_slot"));
            CuriosAPI.registerIcon("body", new ResourceLocation(Curios.MODID, "item/empty_body_slot"));
            CuriosAPI.registerIcon("back", new ResourceLocation(Curios.MODID, "item/empty_back_slot"));
            CuriosAPI.registerIcon("head", new ResourceLocation(Curios.MODID, "item/empty_head_slot"));
            CuriosAPI.registerIcon("belt", new ResourceLocation(Curios.MODID, "item/empty_belt_slot"));
            CuriosAPI.registerIcon("charm", new ResourceLocation(Curios.MODID, "item/empty_charm_slot"));
        }

        @SubscribeEvent
        public static void postSetupClient(FMLLoadCompleteEvent evt) {
            Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
            for (RenderPlayer render : skinMap.values()) {
                render.func_177094_a((LayerRenderer)new LayerCurios());
            }
        }

        public static void onTextureStitch(TextureStitchEvent.Pre evt) {
            TextureMap map = evt.getMap();
            IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
            CuriosRegistry.processIcons();
            for (ResourceLocation resource : CuriosAPI.getIcons().values()) {
                map.func_199362_a(manager, resource);
            }
            map.func_199362_a(manager, new ResourceLocation("curios:item/empty_generic_slot"));
        }

        private static GuiScreen getGuiContainer(FMLPlayMessages.OpenContainer msg) {
            if (msg.getId().equals((Object)CurioContainerHandler.ID)) {
                EntityPlayerSP sp = Minecraft.func_71410_x().field_71439_g;
                PacketBuffer buffer = msg.getAdditionalData();
                return new GuiContainerCurios(new ContainerCurios(sp.field_71071_by, (EntityPlayer)sp), buffer.readFloat(), buffer.readFloat());
            }
            return null;
        }
    }
}

