/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.netty.util.internal.ConcurrentSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CurioType;
import top.theillusivec4.curios.api.CuriosRegistry;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.api.capability.ICurioItemHandler;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;

public class CuriosAPI {
    private static Map<Item, Set<String>> itemToTypes = new HashMap<Item, Set<String>>();
    private static Map<String, Tag<Item>> idToTag = new HashMap<String, Tag<Item>>();

    public static LazyOptional<ICurio> getCurio(ItemStack stack) {
        return stack.getCapability(CuriosCapability.ITEM);
    }

    public static LazyOptional<ICurioItemHandler> getCuriosHandler(@Nonnull EntityLivingBase entityLivingBase) {
        return entityLivingBase.getCapability(CuriosCapability.INVENTORY);
    }

    @Nullable
    public static CurioType getType(String identifier) {
        return CuriosRegistry.idToType.get(identifier);
    }

    public static ImmutableSet<String> getTypeIdentifiers() {
        return ImmutableSet.copyOf(CuriosRegistry.idToType.keySet());
    }

    @Nullable
    public static FinderData getCurioEquipped(Item item, @Nonnull EntityLivingBase entityLivingBase) {
        FinderData found = (FinderData)CuriosAPI.getCuriosHandler(entityLivingBase).map(handler -> {
            ImmutableSet<String> tags = CuriosAPI.getCurioTags(item);
            for (String id : tags) {
                CurioStackHandler stackHandler = handler.getStackHandler(id);
                if (stackHandler == null) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || item != stack.func_77973_b()) continue;
                    return new FinderData(id, i, stack);
                }
            }
            return new FinderData("", 0, ItemStack.field_190927_a);
        }).orElse((Object)new FinderData("", 0, ItemStack.field_190927_a));
        if (!found.getIdentifier().isEmpty()) {
            return found;
        }
        return null;
    }

    @Nullable
    public static FinderData getCurioEquipped(Predicate<ItemStack> filter, @Nonnull EntityLivingBase entityLivingBase) {
        FinderData found = (FinderData)CuriosAPI.getCuriosHandler(entityLivingBase).map(handler -> {
            for (String id : handler.getCurioMap().keySet()) {
                CurioStackHandler stackHandler = handler.getStackHandler(id);
                if (stackHandler == null) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || !filter.test(stack)) continue;
                    return new FinderData(id, i, stack);
                }
            }
            return new FinderData("", 0, ItemStack.field_190927_a);
        }).orElse((Object)new FinderData("", 0, ItemStack.field_190927_a));
        if (!found.getIdentifier().isEmpty()) {
            return found;
        }
        return null;
    }

    public static void addTypeSlotToEntity(String id, EntityLivingBase entityLivingBase) {
        CuriosAPI.addTypeSlotsToEntity(id, 1, entityLivingBase);
    }

    public static void addTypeSlotsToEntity(String id, int amount, EntityLivingBase entityLivingBase) {
        CuriosAPI.getCuriosHandler(entityLivingBase).ifPresent(handler -> handler.addCurioSlot(id, amount));
    }

    public static void removeTypeSlotFromEntity(String id, EntityLivingBase entityLivingBase) {
        CuriosAPI.removeTypeSlotsFromEntity(id, 1, entityLivingBase);
    }

    public static void removeTypeSlotsFromEntity(String id, int amount, EntityLivingBase entityLivingBase) {
        CuriosAPI.getCuriosHandler(entityLivingBase).ifPresent(handler -> handler.removeCurioSlot(id, amount));
    }

    public static void enableTypeForEntity(String id, EntityLivingBase entityLivingBase) {
        CuriosAPI.getCuriosHandler(entityLivingBase).ifPresent(handler -> handler.enableCurio(id));
    }

    public static void disableTypeForEntity(String id, EntityLivingBase entityLivingBase) {
        CuriosAPI.getCuriosHandler(entityLivingBase).ifPresent(handler -> handler.disableCurio(id));
    }

    public static ImmutableSet<String> getCurioTags(Item item) {
        if (idToTag.isEmpty()) {
            idToTag = ItemTags.func_199903_a().func_200039_c().entrySet().stream().filter(map -> ((ResourceLocation)map.getKey()).func_110624_b().equals("curios")).collect(Collectors.toMap(entry -> ((ResourceLocation)entry.getKey()).func_110623_a(), Map.Entry::getValue));
            itemToTypes.clear();
        }
        if (itemToTypes.containsKey(item)) {
            return ImmutableSet.copyOf((Collection)itemToTypes.get(item));
        }
        HashSet tags = Sets.newHashSet();
        for (String identifier : idToTag.keySet()) {
            if (!idToTag.get(identifier).func_199685_a_((Object)item)) continue;
            tags.add(identifier);
        }
        itemToTypes.put(item, tags);
        return ImmutableSet.copyOf((Collection)tags);
    }

    public static void registerIcon(String id, @Nonnull ResourceLocation resourceLocation) {
        CuriosRegistry.iconQueues.computeIfAbsent(id, k -> new ConcurrentSet()).add((Object)resourceLocation);
    }

    public static Map<String, ResourceLocation> getIcons() {
        return ImmutableMap.copyOf(CuriosRegistry.icons);
    }

    public static final class FinderData {
        String identifier;
        int index;
        ItemStack stack;

        public FinderData(String identifier, int index, ItemStack stack) {
            this.identifier = identifier;
            this.index = index;
            this.stack = stack;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public int getIndex() {
            return this.index;
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }

    public static final class IMC {
        public static final String REGISTER_TYPE = "register_type";
        public static final String MODIFY_TYPE = "modify_type";
    }
}

