/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api;

import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.curios.api.CurioType;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;

public class CuriosRegistry {
    static Map<String, CurioType> idToType = new HashMap<String, CurioType>();
    static ConcurrentMap<String, ConcurrentSet<ResourceLocation>> iconQueues = new ConcurrentHashMap<String, ConcurrentSet<ResourceLocation>>();
    static Map<String, ResourceLocation> icons = new HashMap<String, ResourceLocation>();

    public static void processCurioTypes(Stream<InterModComms.IMCMessage> register, Stream<InterModComms.IMCMessage> modify) {
        register.filter(msg -> msg.getMessageSupplier().get() instanceof CurioIMCMessage).map(msg -> (CurioIMCMessage)msg.getMessageSupplier().get()).forEach(msg -> CuriosRegistry.processType(msg, true));
        modify.filter(msg -> msg.getMessageSupplier().get() instanceof CurioIMCMessage).map(msg -> (CurioIMCMessage)msg.getMessageSupplier().get()).forEach(msg -> CuriosRegistry.processType(msg, false));
    }

    public static void processIcons() {
        if (!icons.isEmpty()) {
            icons = new HashMap<String, ResourceLocation>();
        }
        iconQueues.forEach((k, v) -> {
            if (!icons.containsKey(k)) {
                ArrayList sortedList = new ArrayList(v);
                Collections.sort(sortedList);
                icons.put((String)k, (ResourceLocation)sortedList.get(sortedList.size() - 1));
            }
        });
    }

    private static void processType(CurioIMCMessage message, boolean create) {
        String identifier = message.getIdentifier();
        if (idToType.containsKey(identifier)) {
            CurioType presentType = idToType.get(identifier);
            if (message.getSize() > presentType.getSize()) {
                presentType.defaultSize(message.getSize());
            }
            if (!message.isEnabled() && presentType.isEnabled()) {
                presentType.enabled(false);
            }
            if (message.isHidden() && !presentType.isHidden()) {
                presentType.hide(true);
            }
        } else if (create) {
            idToType.put(identifier, new CurioType(identifier).defaultSize(message.getSize()).enabled(message.isEnabled()).hide(message.isHidden()));
        }
    }
}

