/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api.capability;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.model.ModelBase;
import net.minecraft.client.renderer.entity.model.ModelBiped;
import net.minecraft.client.renderer.entity.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;

public interface ICurio {
    default public void onCurioTick(String identifier, EntityLivingBase entityLivingBase) {
    }

    default public void onEquipped(String identifier, EntityLivingBase entityLivingBase) {
    }

    default public void onUnequipped(String identifier, EntityLivingBase entityLivingBase) {
    }

    default public boolean canEquip(String identifier, EntityLivingBase entityLivingBase) {
        return true;
    }

    default public boolean canUnequip(String identifier, EntityLivingBase entityLivingBase) {
        return true;
    }

    default public Multimap<String, AttributeModifier> getAttributeModifiers(String identifier) {
        return HashMultimap.create();
    }

    default public void playEquipSound(EntityLivingBase entityLivingBase) {
        entityLivingBase.field_70170_p.func_184133_a(null, entityLivingBase.func_180425_c(), SoundEvents.field_187719_p, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    default public boolean canRightClickEquip() {
        return false;
    }

    default public boolean shouldSyncToTracking(String identifier, EntityLivingBase entityLivingBase) {
        return false;
    }

    @Nonnull
    default public NBTTagCompound getSyncTag() {
        return new NBTTagCompound();
    }

    default public void readSyncTag(NBTTagCompound compound) {
    }

    default public boolean hasRender(String identifier, EntityLivingBase entityLivingBase) {
        return false;
    }

    default public void doRender(String identifier, EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
    }

    public static final class RenderHelper {
        public static void rotateIfSneaking(EntityLivingBase entitylivingbaseIn) {
            if (entitylivingbaseIn.func_70093_af()) {
                GlStateManager.func_179114_b((float)28.647888f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }

        public static void followHeadRotations(EntityLivingBase entitylivingbaseIn, ModelRenderer ... renderers) {
            ModelBase model;
            Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)entitylivingbaseIn);
            if (render instanceof RenderLivingBase && (model = ((RenderLivingBase)render).func_177087_b()) instanceof ModelBiped) {
                for (ModelRenderer renderer : renderers) {
                    ModelBiped.func_178685_a((ModelRenderer)((ModelBiped)model).field_78116_c, (ModelRenderer)renderer);
                }
            }
        }
    }
}

