/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public final class CurioStackHandler
extends ItemStackHandler {
    protected NonNullList<ItemStack> previousStacks;
    protected boolean isHidden = false;

    public CurioStackHandler() {
        this(1);
    }

    public CurioStackHandler(int size) {
        this.setSize(size);
    }

    public CurioStackHandler(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
        this.previousStacks = NonNullList.func_191196_a();
        for (int i = 0; i < stacks.size(); ++i) {
            this.previousStacks.add((Object)ItemStack.field_190927_a);
        }
    }

    public void setSize(int size) {
        this.stacks = NonNullList.func_191196_a();
        this.previousStacks = NonNullList.func_191196_a();
        for (int i = 0; i < size; ++i) {
            this.stacks.add((Object)ItemStack.field_190927_a);
            this.previousStacks.add((Object)ItemStack.field_190927_a);
        }
    }

    public void setPreviousStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.previousStacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    public int getPreviousSlots() {
        return this.previousStacks.size();
    }

    @Nonnull
    public ItemStack getPreviousStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.previousStacks.get(slot);
    }

    public void addSize(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount cannot be negative!");
        }
        for (int i = 0; i < amount; ++i) {
            this.stacks.add((Object)ItemStack.field_190927_a);
            this.previousStacks.add((Object)ItemStack.field_190927_a);
        }
    }

    public void removeSize(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount cannot be negative!");
        }
        int targetSize = this.stacks.size() - amount;
        while (this.stacks.size() > targetSize) {
            this.stacks.remove(this.stacks.size() - 1);
        }
        while (this.previousStacks.size() > targetSize) {
            this.previousStacks.remove(this.previousStacks.size() - 1);
        }
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74757_a("Hidden", this.isHidden);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.isHidden = nbt.func_150297_b("Hidden", 1) && nbt.func_74767_n("Hidden");
        super.deserializeNBT(nbt);
    }
}

