/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api.inventory;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;

public class SlotCurio
extends SlotItemHandler {
    private final String identifier;
    private final EntityPlayer player;

    public SlotCurio(EntityPlayer player, CurioStackHandler handler, int index, String identifier, int xPosition, int yPosition) {
        super((IItemHandler)handler, index, xPosition, yPosition);
        this.identifier = identifier;
        this.player = player;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getSlotName() {
        String key = "curios.identifier." + this.identifier;
        if (!I18n.func_188566_a((String)key)) {
            return this.identifier.substring(0, 1).toUpperCase() + this.identifier.substring(1);
        }
        return I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        return this.hasValidTag((Set<String>)CuriosAPI.getCurioTags(stack.func_77973_b())) && (Boolean)CuriosAPI.getCurio(stack).map(curio -> curio.canEquip(this.identifier, (EntityLivingBase)this.player)).orElse((Object)true) != false && super.func_75214_a(stack);
    }

    protected boolean hasValidTag(Set<String> tags) {
        return tags.contains(this.identifier);
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        ItemStack stack = this.func_75211_c();
        return (stack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)stack)) && (Boolean)CuriosAPI.getCurio(stack).map(curio -> curio.canUnequip(this.identifier, (EntityLivingBase)playerIn)).orElse((Object)true) != false && super.func_82869_a(playerIn);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public String func_178171_c() {
        return CuriosAPI.getIcons().getOrDefault(this.identifier, new ResourceLocation("curios", "item/empty_generic_slot")).toString();
    }
}

