/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;

public class EventHandlerClient {
    private static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    @SubscribeEvent
    public void onKeyInput(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (KeyRegistry.openCurios.func_151468_f() && mc.func_195544_aj()) {
            NetworkHandler.INSTANCE.sendToServer((Object)new CPacketOpenCurios((float)mc.field_71417_B.func_198024_e(), (float)mc.field_71417_B.func_198026_f()));
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent evt) {
        ItemStack stack = evt.getItemStack();
        if (!stack.func_190926_b()) {
            List tooltip = evt.getToolTip();
            ImmutableSet<String> slots = CuriosAPI.getCurioTags(stack.func_77973_b());
            if (!slots.isEmpty()) {
                for (String s : slots) {
                    String key = "curios.identifier." + s;
                    if (I18n.func_188566_a((String)key)) {
                        tooltip.add(new TextComponentTranslation("curios.identifier." + s, new Object[0]).func_211708_a(TextFormatting.GOLD));
                        continue;
                    }
                    tooltip.add(new TextComponentString(s.substring(0, 1).toUpperCase() + s.substring(1)).func_211708_a(TextFormatting.GOLD));
                }
                CuriosAPI.getCurio(stack).ifPresent(curio -> {
                    for (String identifier : slots) {
                        Multimap<String, AttributeModifier> multimap = curio.getAttributeModifiers(identifier);
                        if (multimap.isEmpty()) continue;
                        EntityPlayer player = evt.getEntityPlayer();
                        tooltip.add(new TextComponentString(""));
                        tooltip.add(new TextComponentTranslation("curios.modifiers", new Object[]{identifier}).func_211708_a(TextFormatting.GOLD));
                        for (Map.Entry entry : multimap.entries()) {
                            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                            double amount = attributemodifier.func_111164_d();
                            boolean flag = false;
                            if (player == null) continue;
                            if (attributemodifier.func_111167_a() == ATTACK_DAMAGE_MODIFIER) {
                                amount += player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
                                amount += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.UNDEFINED);
                                flag = true;
                            } else if (attributemodifier.func_111167_a() == ATTACK_SPEED_MODIFIER) {
                                amount += player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
                                flag = true;
                            }
                            double d1 = attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2 ? amount : amount * 100.0;
                            if (flag) {
                                tooltip.add(new TextComponentString(" ").func_150257_a((ITextComponent)new TextComponentTranslation("attribute.modifier.equals." + attributemodifier.func_111169_c(), new Object[]{ItemStack.field_111284_a.format(d1), new TextComponentTranslation("attribute.name." + (String)entry.getKey(), new Object[0])})).func_211708_a(TextFormatting.DARK_GREEN));
                                continue;
                            }
                            if (amount > 0.0) {
                                tooltip.add(new TextComponentTranslation("attribute.modifier.plus." + attributemodifier.func_111169_c(), new Object[]{ItemStack.field_111284_a.format(d1), new TextComponentTranslation("attribute.name." + (String)entry.getKey(), new Object[0])}).func_211708_a(TextFormatting.BLUE));
                                continue;
                            }
                            if (!(amount < 0.0)) continue;
                            tooltip.add(new TextComponentTranslation("attribute.modifier.take." + attributemodifier.func_111169_c(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TextComponentTranslation("attribute.name." + (String)entry.getKey(), new Object[0])}).func_211708_a(TextFormatting.RED));
                        }
                    }
                });
            }
        }
    }
}

