/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import top.theillusivec4.curios.api.CurioType;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncMap;

public class CommandCurios {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"curios").requires(player -> player.func_197034_c(ServerLifecycleHooks.getCurrentServer().func_110455_j()));
        literalargumentbuilder.then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"slot", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197005_b(CuriosAPI.getTypeIdentifiers(), (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.addSlotToPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"slot"), 1))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandCurios.addSlotToPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        literalargumentbuilder.then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"slot", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197005_b(CuriosAPI.getTypeIdentifiers(), (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.removeSlotFromPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"slot"), 1))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandCurios.removeSlotFromPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        literalargumentbuilder.then(Commands.func_197057_a((String)"enable").then(Commands.func_197056_a((String)"slot", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197005_b(CuriosAPI.getTypeIdentifiers(), (SuggestionsBuilder)builder)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.enableSlotForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"slot"))))));
        literalargumentbuilder.then(Commands.func_197057_a((String)"disable").then(Commands.func_197056_a((String)"slot", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197005_b(CuriosAPI.getTypeIdentifiers(), (SuggestionsBuilder)builder)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.disableSlotForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"slot"))))));
        literalargumentbuilder.then(Commands.func_197057_a((String)"clear").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.clearSlotsForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), ""))).then(Commands.func_197056_a((String)"slot", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197005_b(CuriosAPI.getTypeIdentifiers(), (SuggestionsBuilder)builder)).executes(context -> CommandCurios.clearSlotsForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"slot"))))));
        literalargumentbuilder.then(Commands.func_197057_a((String)"reset").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.resetSlotsForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player")))));
        dispatcher.register(literalargumentbuilder);
    }

    private static int addSlotToPlayer(CommandSource source, EntityPlayerMP playerMP, String slot, int amount) {
        CuriosAPI.addTypeSlotsToEntity(slot, amount, (EntityLivingBase)playerMP);
        source.func_197030_a((ITextComponent)new TextComponentTranslation("commands.curios.add.success", new Object[]{amount, slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int removeSlotFromPlayer(CommandSource source, EntityPlayerMP playerMP, String slot, int amount) {
        CuriosAPI.removeTypeSlotsFromEntity(slot, amount, (EntityLivingBase)playerMP);
        source.func_197030_a((ITextComponent)new TextComponentTranslation("commands.curios.remove.success", new Object[]{amount, slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int enableSlotForPlayer(CommandSource source, EntityPlayerMP playerMP, String slot) {
        CuriosAPI.enableTypeForEntity(slot, (EntityLivingBase)playerMP);
        source.func_197030_a((ITextComponent)new TextComponentTranslation("commands.curios.enable.success", new Object[]{slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int disableSlotForPlayer(CommandSource source, EntityPlayerMP playerMP, String slot) {
        CuriosAPI.disableTypeForEntity(slot, (EntityLivingBase)playerMP);
        source.func_197030_a((ITextComponent)new TextComponentTranslation("commands.curios.disable.success", new Object[]{slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int clearSlotsForPlayer(CommandSource source, EntityPlayerMP playerMP, String slot) {
        CuriosAPI.getCuriosHandler((EntityLivingBase)playerMP).ifPresent(handler -> {
            SortedMap<String, CurioStackHandler> map = handler.getCurioMap();
            if (!slot.isEmpty() && map.get(slot) != null) {
                CommandCurios.clear((CurioStackHandler)((Object)((Object)map.get(slot))));
            } else {
                for (String id : map.keySet()) {
                    CommandCurios.clear((CurioStackHandler)((Object)((Object)map.get(id))));
                }
            }
        });
        if (slot.isEmpty()) {
            source.func_197030_a((ITextComponent)new TextComponentTranslation("commands.curios.clearAll.success", new Object[]{playerMP.func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TextComponentTranslation("commands.curios.clear.success", new Object[]{slot, playerMP.func_145748_c_()}), true);
        }
        return 1;
    }

    private static int resetSlotsForPlayer(CommandSource source, EntityPlayerMP playerMP) {
        CuriosAPI.getCuriosHandler((EntityLivingBase)playerMP).ifPresent(handler -> {
            TreeMap slots = Maps.newTreeMap();
            for (String id : CuriosAPI.getTypeIdentifiers()) {
                CurioType type = CuriosAPI.getType(id);
                if (type == null || !type.isEnabled()) continue;
                slots.put(id, new CurioStackHandler(type.getSize()));
            }
            handler.setCurioMap(slots);
            NetworkHandler.INSTANCE.sendTo((Object)new SPacketSyncMap(playerMP.func_145782_y(), handler.getCurioMap()), playerMP.field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
        });
        source.func_197030_a((ITextComponent)new TextComponentTranslation("commands.curios.reset.success", new Object[]{playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static void clear(CurioStackHandler stacks) {
        for (int i = 0; i < stacks.getSlots(); ++i) {
            stacks.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }
}

