/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CuriosConfig {
    private static final String CONFIG_PREFIX = "gui.curios.config.";
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue renderCurios;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only settings, mostly things related to rendering").push("client");
            this.renderCurios = builder.comment("Set to true to enable rendering curios").translation("gui.curios.config.renderCurios").define("renderCurios", true);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<String>> disabledCurios;
        public final ForgeConfigSpec.ConfigValue<List<String>> createCurios;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("common");
            this.disabledCurios = builder.comment("List of curio types to disable by default").translation("gui.curios.config.disabledCurios").worldRestart().define("disabledCurios", (Object)Lists.newArrayList());
            this.createCurios = builder.comment("List of curio types to create").translation("gui.curios.config.createCurios").worldRestart().define("createCurios", (Object)Lists.newArrayList());
            builder.pop();
        }
    }
}

