/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.capability;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CurioType;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurioItemHandler;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncActive;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncSize;

public class CapCurioInventory {
    public static void register() {
        CapabilityManager.INSTANCE.register(ICurioItemHandler.class, (Capability.IStorage)new Capability.IStorage<ICurioItemHandler>(){

            public INBTBase writeNBT(Capability<ICurioItemHandler> capability, ICurioItemHandler instance, EnumFacing side) {
                SortedMap<String, CurioStackHandler> curioMap = instance.getCurioMap();
                NBTTagCompound compound = new NBTTagCompound();
                NBTTagList taglist = new NBTTagList();
                for (String identifier : curioMap.keySet()) {
                    CurioStackHandler stackHandler = (CurioStackHandler)((Object)curioMap.get(identifier));
                    NBTTagCompound itemtag = stackHandler.serializeNBT();
                    itemtag.func_74778_a("Identifier", identifier);
                    taglist.add((INBTBase)itemtag);
                }
                compound.func_74782_a("Curios", (INBTBase)taglist);
                NBTTagList taglist1 = new NBTTagList();
                for (String identifier : instance.getDisabled()) {
                    taglist1.add((INBTBase)new NBTTagString(identifier));
                }
                compound.func_74782_a("Disabled", (INBTBase)taglist1);
                return compound;
            }

            public void readNBT(Capability<ICurioItemHandler> capability, ICurioItemHandler instance, EnumFacing side, INBTBase nbt) {
                NBTTagList tagList = ((NBTTagCompound)nbt).func_150295_c("Curios", 10);
                NBTTagList tagList1 = ((NBTTagCompound)nbt).func_150295_c("Disabled", 8);
                HashSet disabled = Sets.newHashSet();
                for (int k = 0; k < tagList1.size(); ++k) {
                    disabled.add(tagList1.func_150307_f(k));
                }
                instance.setDisabled(disabled);
                if (!tagList.isEmpty()) {
                    SortedMap<String, CurioStackHandler> curios = instance.getDefaultSlots();
                    for (int i = 0; i < tagList.size(); ++i) {
                        NBTTagCompound itemtag = tagList.func_150305_b(i);
                        String identifier = itemtag.func_74779_i("Identifier");
                        CurioType type = CuriosAPI.getType(identifier);
                        CurioStackHandler stackHandler = new CurioStackHandler();
                        stackHandler.deserializeNBT(itemtag);
                        if (type != null) {
                            curios.put(identifier, stackHandler);
                            continue;
                        }
                        for (int j = 0; j < stackHandler.getSlots(); ++j) {
                            ItemStack stack = stackHandler.getStackInSlot(j);
                            if (stack.func_190926_b()) continue;
                            instance.addInvalid(stackHandler.getStackInSlot(j));
                        }
                    }
                    instance.setCurioMap(curios);
                }
            }
        }, CurioInventoryWrapper::new);
    }

    public static ICapabilityProvider createProvider(EntityLivingBase livingBase) {
        return new Provider(livingBase);
    }

    public static class Provider
    implements ICapabilitySerializable<INBTBase> {
        final LazyOptional<ICurioItemHandler> optional;
        final ICurioItemHandler handler;

        Provider(EntityLivingBase livingBase) {
            this.handler = new CurioInventoryWrapper(livingBase);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, EnumFacing facing) {
            return CuriosCapability.INVENTORY.orEmpty(capability, this.optional);
        }

        public INBTBase serializeNBT() {
            return CuriosCapability.INVENTORY.writeNBT((Object)this.handler, null);
        }

        public void deserializeNBT(INBTBase nbt) {
            CuriosCapability.INVENTORY.readNBT((Object)this.handler, null, nbt);
        }
    }

    public static class CurioInventoryWrapper
    implements ICurioItemHandler {
        SortedMap<String, CurioStackHandler> curioSlots;
        NonNullList<ItemStack> invalidCache;
        Set<String> disabled = Sets.newHashSet();
        EntityLivingBase wearer;

        CurioInventoryWrapper() {
            this(null);
        }

        CurioInventoryWrapper(EntityLivingBase livingBase) {
            this.curioSlots = this.getDefaultSlots();
            this.invalidCache = NonNullList.func_191196_a();
            this.wearer = livingBase;
        }

        @Override
        public void setStackInSlot(String identifier, int slot, @Nonnull ItemStack stack) {
            ((CurioStackHandler)((Object)this.curioSlots.get(identifier))).setStackInSlot(slot, stack);
        }

        @Override
        public SortedMap<String, CurioStackHandler> getDefaultSlots() {
            TreeMap slots = Maps.newTreeMap();
            for (String id : CuriosAPI.getTypeIdentifiers()) {
                CurioType type;
                if (!this.disabled.isEmpty() && this.disabled.contains(id) || (type = CuriosAPI.getType(id)) == null || !type.isEnabled()) continue;
                CurioStackHandler handler = new CurioStackHandler(type.getSize());
                handler.setHidden(type.isHidden());
                slots.put(id, handler);
            }
            return slots;
        }

        @Override
        public int getSlots() {
            int totalSlots = 0;
            for (ItemStackHandler itemStackHandler : this.curioSlots.values()) {
                totalSlots += itemStackHandler.getSlots();
            }
            return totalSlots;
        }

        @Override
        @Nonnull
        public ItemStack getStackInSlot(String identifier, int slot) {
            return ((CurioStackHandler)((Object)this.curioSlots.get(identifier))).getStackInSlot(slot);
        }

        @Override
        @Nullable
        public CurioStackHandler getStackHandler(String identifier) {
            return (CurioStackHandler)((Object)this.curioSlots.get(identifier));
        }

        @Override
        public SortedMap<String, CurioStackHandler> getCurioMap() {
            return Collections.unmodifiableSortedMap(this.curioSlots);
        }

        @Override
        public void setCurioMap(SortedMap<String, CurioStackHandler> map) {
            this.curioSlots = map;
        }

        @Override
        public void enableCurio(String identifier) {
            CurioType type = CuriosAPI.getType(identifier);
            if (type != null) {
                this.curioSlots.putIfAbsent(identifier, new CurioStackHandler(type.getSize()));
                this.disabled.remove(identifier);
                if (!this.wearer.field_70170_p.field_72995_K && this.wearer instanceof EntityPlayerMP) {
                    NetworkHandler.INSTANCE.sendTo((Object)new SPacketSyncActive(this.wearer.func_145782_y(), identifier, false), ((EntityPlayerMP)this.wearer).field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        }

        @Override
        public void disableCurio(String identifier) {
            CurioStackHandler stackHandler = (CurioStackHandler)((Object)this.curioSlots.get(identifier));
            if (stackHandler != null) {
                this.dropOrGiveLast(stackHandler, identifier, stackHandler.getSlots());
                this.curioSlots.remove(identifier);
                this.disabled.add(identifier);
                if (this.wearer instanceof EntityPlayerMP) {
                    NetworkHandler.INSTANCE.sendTo((Object)new SPacketSyncActive(this.wearer.func_145782_y(), identifier, true), ((EntityPlayerMP)this.wearer).field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        }

        @Override
        public void addCurioSlot(String identifier, int amount) {
            CurioStackHandler stackHandler;
            if (amount > 0 && (stackHandler = (CurioStackHandler)((Object)this.curioSlots.get(identifier))) != null) {
                stackHandler.addSize(amount);
                if (this.wearer instanceof EntityPlayerMP) {
                    NetworkHandler.INSTANCE.sendTo((Object)new SPacketSyncSize(this.wearer.func_145782_y(), identifier, amount, false), ((EntityPlayerMP)this.wearer).field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        }

        @Override
        public void removeCurioSlot(String identifier, int amount) {
            CurioStackHandler stackHandler;
            if (amount > 0 && (stackHandler = (CurioStackHandler)((Object)this.curioSlots.get(identifier))) != null) {
                amount = Math.min(stackHandler.getSlots() - 1, amount);
                this.dropOrGiveLast(stackHandler, identifier, amount);
                if (this.wearer instanceof EntityPlayerMP) {
                    NetworkHandler.INSTANCE.sendTo((Object)new SPacketSyncSize(this.wearer.func_145782_y(), identifier, amount, true), ((EntityPlayerMP)this.wearer).field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
                stackHandler.removeSize(amount);
            }
        }

        @Override
        @Nullable
        public EntityLivingBase getWearer() {
            return this.wearer;
        }

        @Override
        public ImmutableSet<String> getDisabled() {
            return ImmutableSet.copyOf(this.disabled);
        }

        @Override
        public void setDisabled(Set<String> disabled) {
            this.disabled = disabled;
        }

        @Override
        public void addInvalid(ItemStack stack) {
            this.invalidCache.add((Object)stack);
        }

        @Override
        public void dropInvalidCache() {
            if (!this.invalidCache.isEmpty()) {
                this.dropOrGive(this.invalidCache);
                this.invalidCache = NonNullList.func_191196_a();
            }
        }

        private void dropOrGiveLast(ItemStackHandler stackHandler, String identifier, int amount) {
            if (!this.wearer.field_70170_p.field_72995_K) {
                NonNullList drops = NonNullList.func_191196_a();
                for (int i = stackHandler.getSlots() - amount; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    drops.add((Object)stackHandler.getStackInSlot(i));
                    CuriosAPI.getCurio(stack).ifPresent(curio -> {
                        if (!stack.func_190926_b()) {
                            this.wearer.func_110140_aT().func_111148_a(curio.getAttributeModifiers(identifier));
                        }
                    });
                    stackHandler.setStackInSlot(i, ItemStack.field_190927_a);
                }
                this.dropOrGive((NonNullList<ItemStack>)drops);
            }
        }

        private void dropOrGive(NonNullList<ItemStack> drops) {
            if (this.wearer instanceof EntityPlayer) {
                for (ItemStack drop : drops) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)this.wearer), (ItemStack)drop);
                }
            } else {
                for (ItemStack drop : drops) {
                    this.wearer.func_70099_a(drop, 0.0f);
                }
            }
        }
    }
}

