/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.event;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.SortedMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.api.event.LivingCurioChangeEvent;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import top.theillusivec4.curios.common.capability.CapCurioInventory;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncContents;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncContentsWithTag;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncMap;

public class EventHandlerCurios {
    @SubscribeEvent
    public void onCapabilitiesEntity(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof EntityPlayer) {
            evt.addCapability(CuriosCapability.ID_INVENTORY, CapCurioInventory.createProvider((EntityLivingBase)((EntityPlayer)evt.getObject())));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase livingBase = (EntityLivingBase)evt.getEntity();
            CuriosAPI.getCuriosHandler(livingBase).ifPresent(handler -> {
                handler.dropInvalidCache();
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP mp = (EntityPlayerMP)entity;
                    NetworkHandler.INSTANCE.sendTo((Object)new SPacketSyncMap(mp.func_145782_y(), handler.getCurioMap()), mp.field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking evt) {
        Entity target = evt.getTarget();
        EntityPlayer player = evt.getEntityPlayer();
        if (player instanceof EntityPlayerMP && target instanceof EntityLivingBase) {
            EntityLivingBase livingBase = (EntityLivingBase)target;
            CuriosAPI.getCuriosHandler(livingBase).ifPresent(handler -> NetworkHandler.INSTANCE.sendTo((Object)new SPacketSyncMap(livingBase.func_145782_y(), handler.getCurioMap()), ((EntityPlayerMP)player).field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone evt) {
        EntityPlayer player = evt.getEntityPlayer();
        if (!evt.isWasDeath() || player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            CuriosAPI.getCuriosHandler((EntityLivingBase)evt.getOriginal()).ifPresent(originalHandler -> CuriosAPI.getCuriosHandler((EntityLivingBase)player).ifPresent(newHandler -> newHandler.setCurioMap(originalHandler.getCurioMap())));
        }
    }

    @SubscribeEvent
    public void onPlayerDrops(PlayerDropsEvent evt) {
        EntityPlayer player = evt.getEntityPlayer();
        if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && !player.func_175149_v()) {
            CuriosAPI.getCuriosHandler((EntityLivingBase)player).ifPresent(handler -> {
                Collection entityItems = evt.getDrops();
                SortedMap<String, CurioStackHandler> curioMap = handler.getCurioMap();
                for (String identifier : curioMap.keySet()) {
                    ItemStackHandler stacks = (ItemStackHandler)curioMap.get(identifier);
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        ItemStack stack = stacks.getStackInSlot(i);
                        if (stack.func_190926_b()) continue;
                        if (!EnchantmentHelper.func_190939_c((ItemStack)stack)) {
                            entityItems.add(this.getDroppedItem(stack, player));
                        }
                        stacks.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerXPPickUp(PlayerPickupXpEvent evt) {
        EntityPlayer player = evt.getEntityPlayer();
        if (!player.field_70170_p.field_72995_K) {
            CuriosAPI.getCuriosHandler((EntityLivingBase)player).ifPresent(handler -> {
                SortedMap<String, CurioStackHandler> curioMap = handler.getCurioMap();
                for (String identifier : curioMap.keySet()) {
                    ItemStackHandler stacks = (ItemStackHandler)curioMap.get(identifier);
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        ItemStack stack = stacks.getStackInSlot(i);
                        if (stack.func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) <= 0 || !stack.func_77951_h()) continue;
                        evt.setCanceled(true);
                        EntityXPOrb orb = evt.getOrb();
                        player.field_71090_bL = 2;
                        player.func_71001_a((Entity)orb, 1);
                        int toRepair = Math.min(orb.field_70530_e * 2, stack.func_77952_i());
                        orb.field_70530_e -= toRepair / 2;
                        stack.func_196085_b(stack.func_77952_i() - toRepair);
                        if (orb.field_70530_e > 0) {
                            player.func_195068_e(orb.field_70530_e);
                        }
                        orb.func_70106_y();
                        return;
                    }
                }
            });
        }
    }

    private EntityItem getDroppedItem(ItemStack droppedItem, EntityPlayer player) {
        double d0 = player.field_70163_u - (double)0.3f + (double)player.func_70047_e();
        EntityItem entityitem = new EntityItem(player.field_70170_p, player.field_70165_t, d0, player.field_70161_v, droppedItem);
        entityitem.func_174867_a(40);
        float f = player.field_70170_p.field_73012_v.nextFloat() * 0.5f;
        float f1 = player.field_70170_p.field_73012_v.nextFloat() * ((float)Math.PI * 2);
        entityitem.field_70159_w = -MathHelper.func_76126_a((float)f1) * f;
        entityitem.field_70179_y = MathHelper.func_76134_b((float)f1) * f;
        entityitem.field_70181_x = 0.2f;
        return entityitem;
    }

    @SubscribeEvent
    public void onCurioRightClick(PlayerInteractEvent.RightClickItem evt) {
        EntityPlayer player = evt.getEntityPlayer();
        ItemStack stack = evt.getItemStack();
        CuriosAPI.getCurio(stack).ifPresent(curio -> {
            if (curio.canRightClickEquip()) {
                CuriosAPI.getCuriosHandler((EntityLivingBase)player).ifPresent(handler -> {
                    if (!player.field_70170_p.field_72995_K) {
                        SortedMap<String, CurioStackHandler> curios = handler.getCurioMap();
                        ImmutableSet<String> tags = CuriosAPI.getCurioTags(stack.func_77973_b());
                        for (String id : tags) {
                            ItemStackHandler stackHandler;
                            if (!curio.canEquip(id, (EntityLivingBase)player) || (stackHandler = (ItemStackHandler)curios.get(id)) == null) continue;
                            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                                if (!stackHandler.getStackInSlot(i).func_190926_b()) continue;
                                stackHandler.setStackInSlot(i, stack.func_77946_l());
                                curio.playEquipSound((EntityLivingBase)player);
                                stack.func_190918_g(1);
                                evt.setCancellationResult(EnumActionResult.SUCCESS);
                                evt.setCanceled(true);
                                return;
                            }
                        }
                    } else {
                        evt.setCancellationResult(EnumActionResult.SUCCESS);
                        evt.setCanceled(true);
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public void onCurioTick(LivingEvent.LivingUpdateEvent evt) {
        EntityLivingBase entitylivingbase = evt.getEntityLiving();
        CuriosAPI.getCuriosHandler(entitylivingbase).ifPresent(handler -> {
            SortedMap<String, CurioStackHandler> curios = handler.getCurioMap();
            for (String identifier : curios.keySet()) {
                CurioStackHandler stackHandler = (CurioStackHandler)((Object)((Object)curios.get(identifier)));
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack prevStack;
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    stack.func_77945_a(entitylivingbase.field_70170_p, (Entity)entitylivingbase, -1, false);
                    LazyOptional<ICurio> currentCurio = CuriosAPI.getCurio(stack);
                    currentCurio.ifPresent(curio -> curio.onCurioTick(identifier, entitylivingbase));
                    if (entitylivingbase.field_70170_p.field_72995_K || ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(prevStack = stackHandler.getPreviousStackInSlot(i)))) continue;
                    LazyOptional<ICurio> prevCurio = CuriosAPI.getCurio(prevStack);
                    boolean shouldSync = !stack.equals(prevStack, true);
                    NBTTagCompound syncTag = new NBTTagCompound();
                    if (((Boolean)currentCurio.map(curio -> curio.shouldSyncToTracking(identifier, entitylivingbase)).orElse((Object)false)).booleanValue() || ((Boolean)prevCurio.map(curio -> curio.shouldSyncToTracking(identifier, entitylivingbase)).orElse((Object)false)).booleanValue() || shouldSync) {
                        EntityTracker tracker = ((WorldServer)entitylivingbase.field_70170_p).func_73039_n();
                        if (currentCurio.isPresent()) {
                            syncTag = (NBTTagCompound)currentCurio.map(ICurio::getSyncTag).orElse((Object)syncTag);
                        }
                        for (EntityPlayer player : tracker.getTrackingPlayers((Entity)entitylivingbase)) {
                            if (!(player instanceof EntityPlayerMP)) continue;
                            if (!syncTag.isEmpty()) {
                                NetworkHandler.INSTANCE.sendTo((Object)new SPacketSyncContentsWithTag(entitylivingbase.func_145782_y(), identifier, i, stack, syncTag), ((EntityPlayerMP)player).field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
                                continue;
                            }
                            NetworkHandler.INSTANCE.sendTo((Object)new SPacketSyncContents(entitylivingbase.func_145782_y(), identifier, i, stack), ((EntityPlayerMP)player).field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
                        }
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new LivingCurioChangeEvent(entitylivingbase, identifier, i, prevStack, stack));
                    prevCurio.ifPresent(curio -> {
                        entitylivingbase.func_110140_aT().func_111148_a(curio.getAttributeModifiers(identifier));
                        curio.onUnequipped(identifier, entitylivingbase);
                    });
                    currentCurio.ifPresent(curio -> {
                        entitylivingbase.func_110140_aT().func_111147_b(curio.getAttributeModifiers(identifier));
                        curio.onEquipped(identifier, entitylivingbase);
                    });
                    stackHandler.setPreviousStackInSlot(i, stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l());
                    if (!(entitylivingbase instanceof EntityPlayerMP)) continue;
                    if (!syncTag.isEmpty()) {
                        NetworkHandler.INSTANCE.sendTo((Object)new SPacketSyncContentsWithTag(entitylivingbase.func_145782_y(), identifier, i, stack, syncTag), ((EntityPlayerMP)entitylivingbase).field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
                        continue;
                    }
                    NetworkHandler.INSTANCE.sendTo((Object)new SPacketSyncContents(entitylivingbase.func_145782_y(), identifier, i, stack), ((EntityPlayerMP)entitylivingbase).field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        });
    }
}

