/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import java.util.SortedMap;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkDirection;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.ICurioItemHandler;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import top.theillusivec4.curios.api.inventory.SlotCurio;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketScrollCurios;
import top.theillusivec4.curios.common.network.server.SPacketScrollCurios;

public class ContainerCurios
extends Container {
    private static final String[] EMPTY_SLOT_NAMES = new String[]{"minecraft:item/empty_armor_slot_boots", "minecraft:item/empty_armor_slot_leggings", "minecraft:item/empty_armor_slot_chestplate", "minecraft:item/empty_armor_slot_helmet"};
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public final LazyOptional<ICurioItemHandler> curios;
    private final EntityPlayer player;
    private final boolean isLocalWorld;
    private InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 2, 2);
    private InventoryCraftResult craftResult = new InventoryCraftResult();
    private int lastScrollIndex;

    public ContainerCurios(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.player = playerIn;
        this.isLocalWorld = playerIn.field_70170_p.field_72995_K;
        this.curios = CuriosAPI.getCuriosHandler((EntityLivingBase)playerIn);
        this.func_75146_a((Slot)new SlotCrafting(playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 154, 28));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * 2, 98 + j * 18, 18 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[k];
            this.func_75146_a(new Slot((IInventory)playerInventory, 36 + (3 - k), 8, 8 + k * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.canEquip(entityequipmentslot, (Entity)ContainerCurios.this.player);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return (itemstack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(playerIn);
                }

                @OnlyIn(value=Dist.CLIENT)
                public String func_178171_c() {
                    return EMPTY_SLOT_NAMES[entityequipmentslot.func_188454_b()];
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i1, 8 + i1 * 18, 142));
        }
        this.func_75146_a(new Slot((IInventory)playerInventory, 40, 77, 62){

            @OnlyIn(value=Dist.CLIENT)
            public String func_178171_c() {
                return "minecraft:item/empty_armor_slot_shield";
            }
        });
        this.curios.ifPresent(curios -> {
            SortedMap<String, CurioStackHandler> curioMap = curios.getCurioMap();
            int slots = 0;
            int yOffset = 12;
            for (String identifier : curioMap.keySet()) {
                CurioStackHandler stackHandler = (CurioStackHandler)((Object)((Object)curioMap.get(identifier)));
                if (stackHandler.isHidden()) continue;
                for (int i = 0; i < stackHandler.getSlots() && slots < 8; ++slots, ++i) {
                    this.func_75146_a((Slot)new SlotCurio(this.player, stackHandler, i, identifier, -18, yOffset));
                    yOffset += 18;
                }
            }
        });
        this.scrollToIndex(0);
    }

    public void scrollToIndex(int indexIn) {
        this.curios.ifPresent(curios -> {
            SortedMap<String, CurioStackHandler> curioMap = curios.getCurioMap();
            int slots = 0;
            int yOffset = 12;
            int index = 0;
            this.field_75151_b.subList(46, this.field_75151_b.size()).clear();
            this.field_75153_a.subList(46, this.field_75153_a.size()).clear();
            for (String identifier : curioMap.keySet()) {
                CurioStackHandler stackHandler = (CurioStackHandler)((Object)((Object)curioMap.get(identifier)));
                if (stackHandler.isHidden()) continue;
                for (int i = 0; i < stackHandler.getSlots() && slots < 8; ++i) {
                    if (index >= indexIn) {
                        this.func_75146_a((Slot)new SlotCurio(this.player, stackHandler, i, identifier, -18, yOffset));
                        yOffset += 18;
                        ++slots;
                    }
                    ++index;
                }
            }
            if (!this.isLocalWorld) {
                NetworkHandler.INSTANCE.sendTo((Object)new SPacketScrollCurios(this.field_75152_c, indexIn), ((EntityPlayerMP)this.player).field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
            this.lastScrollIndex = indexIn;
        });
    }

    public void scrollTo(float pos) {
        this.curios.ifPresent(curios -> {
            int k = curios.getSlots() - 8;
            int j = (int)((double)(pos * (float)k) + 0.5);
            if (j < 0) {
                j = 0;
            }
            if (j == this.lastScrollIndex) {
                return;
            }
            if (this.isLocalWorld) {
                NetworkHandler.INSTANCE.sendToServer((Object)new CPacketScrollCurios(this.field_75152_c, j));
            }
        });
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.func_192389_a(this.player.field_70170_p, this.player, (IInventory)this.craftMatrix, this.craftResult);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.craftResult.func_174888_l();
        if (!playerIn.field_70170_p.field_72995_K) {
            this.func_193327_a(playerIn, playerIn.field_70170_p, (IInventory)this.craftMatrix);
        }
    }

    public boolean canScroll() {
        return (Integer)this.curios.map(curios -> {
            if (curios.getSlots() > 8) {
                return 1;
            }
            return 0;
        }).orElse((Object)0) == 1;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            int i;
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d((ItemStack)itemstack);
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 9, 45, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index < 5 ? !this.func_75135_a(itemstack1, 9, 45, false) : (index < 9 ? !this.func_75135_a(itemstack1, 9, 45, false) : (entityequipmentslot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR && !((Slot)this.field_75151_b.get(8 - entityequipmentslot.func_188454_b())).func_75216_d() ? !this.func_75135_a(itemstack1, i = 8 - entityequipmentslot.func_188454_b(), i + 1, false) : (index < 46 && CuriosAPI.getCurio(itemstack).isPresent() ? this.func_75135_a(itemstack1, 46, this.field_75151_b.size(), false) : (entityequipmentslot == EntityEquipmentSlot.OFFHAND && !((Slot)this.field_75151_b.get(45)).func_75216_d() ? !this.func_75135_a(itemstack1, 45, 46, false) : !this.func_75135_a(itemstack1, 9, 45, false)))))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }
}

