/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.common.capability.CapCurioItem;

public class ItemRing
extends Item
implements ICurio {
    private static final UUID SPEED_UUID = UUID.fromString("8b7c8fcd-89bc-4794-8bb9-eddeb32753a5");
    private static final UUID ARMOR_UUID = UUID.fromString("38faf191-bf78-4654-b349-cc1f4f1143bf");

    public ItemRing() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1).func_200915_b(0));
        this.setRegistryName("curios", "ring");
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound unused) {
        return CapCurioItem.createProvider(new ICurio(){

            @Override
            public void onCurioTick(String identifier, EntityLivingBase entityLivingBase) {
                if (!entityLivingBase.func_130014_f_().field_72995_K && entityLivingBase.field_70173_aa % 19 == 0) {
                    entityLivingBase.func_195064_c(new PotionEffect(MobEffects.field_76422_e, 20, 0, true, true));
                }
            }

            @Override
            public void playEquipSound(EntityLivingBase entityLivingBase) {
                entityLivingBase.field_70170_p.func_184133_a(null, entityLivingBase.func_180425_c(), SoundEvents.field_187722_q, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }

            @Override
            public Multimap<String, AttributeModifier> getAttributeModifiers(String identifier) {
                HashMultimap atts = HashMultimap.create();
                if (CuriosAPI.getCurioTags(stack.func_77973_b()).contains((Object)identifier)) {
                    atts.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(SPEED_UUID, "Speed bonus", 0.1, 2));
                    atts.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_UUID, "Armor bonus", 2.0, 0));
                }
                return atts;
            }

            @Override
            public boolean canRightClickEquip() {
                return true;
            }
        });
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }
}

