/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.client;

import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import top.theillusivec4.curios.common.inventory.CurioContainerHandler;

public class CPacketOpenCurios {
    private float oldMouseX;
    private float oldMouseY;

    public CPacketOpenCurios(float oldMouseX, float oldMouseY) {
        this.oldMouseX = oldMouseX;
        this.oldMouseY = oldMouseY;
    }

    public static void encode(CPacketOpenCurios msg, PacketBuffer buf) {
        buf.writeFloat(msg.oldMouseX);
        buf.writeFloat(msg.oldMouseY);
    }

    public static CPacketOpenCurios decode(PacketBuffer buf) {
        return new CPacketOpenCurios(buf.readFloat(), buf.readFloat());
    }

    public static void handle(CPacketOpenCurios msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            EntityPlayerMP sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                NetworkHooks.openGui((EntityPlayerMP)sender, (IInteractionObject)new CurioContainerHandler(), buf -> {
                    buf.writeFloat(msg.oldMouseX);
                    buf.writeFloat(msg.oldMouseY);
                });
            }
        });
    }
}

