/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosAPI;

public class SPacketSyncSize {
    private int entityId;
    private String curioId;
    private int amount;
    private boolean remove;

    public SPacketSyncSize(int entityId, String curioId, int amount, boolean remove) {
        this.entityId = entityId;
        this.curioId = curioId;
        this.amount = amount;
        this.remove = remove;
    }

    public static void encode(SPacketSyncSize msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_180714_a(msg.curioId);
        buf.writeInt(msg.amount);
        buf.writeBoolean(msg.remove);
    }

    public static SPacketSyncSize decode(PacketBuffer buf) {
        return new SPacketSyncSize(buf.readInt(), buf.func_150789_c(25), buf.readInt(), buf.readBoolean());
    }

    public static void handle(SPacketSyncSize msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
            if (entity instanceof EntityLivingBase) {
                CuriosAPI.getCuriosHandler((EntityLivingBase)entity).ifPresent(handler -> {
                    if (msg.remove) {
                        handler.removeCurioSlot(msg.curioId, msg.amount);
                    } else {
                        handler.addCurioSlot(msg.curioId, msg.amount);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

