/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.logging.log4j.util.TriConsumer;
import top.theillusivec4.curios.api.CurioType;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.api.capability.ICurioItemHandler;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;

public final class CuriosAPI {
    public static final String MODID = "curios";
    private static final ResourceLocation GENERIC_SLOT = new ResourceLocation("curios", "textures/item/empty_generic_slot.png");
    public static Map<String, CurioType> idToType = new HashMap<String, CurioType>();
    public static Map<String, ResourceLocation> idToIcon = new HashMap<String, ResourceLocation>();
    public static TriConsumer<String, Integer, LivingEntity> brokenCurioConsumer;

    public static LazyOptional<ICurio> getCurio(ItemStack stack) {
        return stack.getCapability(CuriosCapability.ITEM);
    }

    public static LazyOptional<ICurioItemHandler> getCuriosHandler(@Nonnull LivingEntity livingEntity) {
        return livingEntity.getCapability(CuriosCapability.INVENTORY);
    }

    public static void onBrokenCurio(String id, int index, LivingEntity damager) {
        brokenCurioConsumer.accept((Object)id, (Object)index, (Object)damager);
    }

    public static Optional<CurioType> getType(String identifier) {
        return Optional.ofNullable(idToType.get(identifier));
    }

    public static Set<String> getTypeIdentifiers() {
        return Collections.unmodifiableSet(idToType.keySet());
    }

    public static int getSlotsForType(@Nonnull LivingEntity livingEntity, String identifier) {
        return (Integer)CuriosAPI.getCuriosHandler(livingEntity).map(handler -> {
            CurioStackHandler stacks = (CurioStackHandler)((Object)((Object)handler.getCurioMap().get(identifier)));
            return stacks != null ? stacks.getSlots() : 0;
        }).orElse((Object)0);
    }

    public static void setSlotsForType(String id, LivingEntity livingEntity, int amount) {
        int difference = amount - CuriosAPI.getSlotsForType(livingEntity, id);
        if (difference > 0) {
            CuriosAPI.addTypeSlotsToEntity(id, difference, livingEntity);
        } else if (difference < 0) {
            CuriosAPI.removeTypeSlotsFromEntity(id, Math.abs(difference), livingEntity);
        }
    }

    public static Optional<ImmutableTriple<String, Integer, ItemStack>> getCurioEquipped(Item item, @Nonnull LivingEntity livingEntity) {
        ImmutableTriple result = (ImmutableTriple)CuriosAPI.getCuriosHandler(livingEntity).map(handler -> {
            Set<String> tags = CuriosAPI.getCurioTags(item);
            for (String id : tags) {
                CurioStackHandler stackHandler = handler.getStackHandler(id);
                if (stackHandler == null) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || item != stack.func_77973_b()) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
            }
            return new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a);
        }).orElse((Object)new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a));
        return ((String)result.getLeft()).isEmpty() ? Optional.empty() : Optional.of(result);
    }

    @Nonnull
    public static Optional<ImmutableTriple<String, Integer, ItemStack>> getCurioEquipped(Predicate<ItemStack> filter, @Nonnull LivingEntity livingEntity) {
        ImmutableTriple result = (ImmutableTriple)CuriosAPI.getCuriosHandler(livingEntity).map(handler -> {
            for (String id : handler.getCurioMap().keySet()) {
                CurioStackHandler stackHandler = handler.getStackHandler(id);
                if (stackHandler == null) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
            }
            return new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a);
        }).orElse((Object)new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a));
        return ((String)result.getLeft()).isEmpty() ? Optional.empty() : Optional.of(result);
    }

    public static void addTypeSlotToEntity(String id, LivingEntity entityLivingBase) {
        CuriosAPI.addTypeSlotsToEntity(id, 1, entityLivingBase);
    }

    public static void addTypeSlotsToEntity(String id, int amount, LivingEntity entityLivingBase) {
        CuriosAPI.getCuriosHandler(entityLivingBase).ifPresent(handler -> handler.addCurioSlot(id, amount));
    }

    public static void removeTypeSlotFromEntity(String id, LivingEntity entityLivingBase) {
        CuriosAPI.removeTypeSlotsFromEntity(id, 1, entityLivingBase);
    }

    public static void removeTypeSlotsFromEntity(String id, int amount, LivingEntity entityLivingBase) {
        CuriosAPI.getCuriosHandler(entityLivingBase).ifPresent(handler -> handler.removeCurioSlot(id, amount));
    }

    public static void enableTypeForEntity(String id, LivingEntity entityLivingBase) {
        CuriosAPI.getCuriosHandler(entityLivingBase).ifPresent(handler -> handler.enableCurio(id));
    }

    public static void disableTypeForEntity(String id, LivingEntity entityLivingBase) {
        CuriosAPI.getCuriosHandler(entityLivingBase).ifPresent(handler -> handler.disableCurio(id));
    }

    public static Set<String> getCurioTags(Item item) {
        return item.getTags().stream().filter(tag -> tag.func_110624_b().equals(MODID)).map(ResourceLocation::func_110623_a).collect(Collectors.toSet());
    }

    @Nonnull
    public static ResourceLocation getIcon(String identifier) {
        return idToIcon.getOrDefault(identifier, GENERIC_SLOT);
    }

    public static final class IMC {
        public static final String REGISTER_TYPE = "register_type";
        public static final String MODIFY_TYPE = "modify_type";
        public static final String REGISTER_ICON = "register_icon";
    }
}

