/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;

public class SlotCurio
extends SlotItemHandler {
    private static AtlasSpriteHolder sprites;
    private final String identifier;
    private final PlayerEntity player;

    public SlotCurio(PlayerEntity player, CurioStackHandler handler, int index, String identifier, int xPosition, int yPosition) {
        super((IItemHandler)handler, index, xPosition, yPosition);
        this.identifier = identifier;
        this.player = player;
        this.backgroundLocation = CuriosAPI.getIcon(identifier);
        if (this.player.field_70170_p.field_72995_K && sprites == null) {
            sprites = new AtlasSpriteHolder();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getSlotName() {
        return I18n.func_135052_a((String)("curios.identifier." + this.identifier), (Object[])new Object[0]);
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        return this.hasValidTag(CuriosAPI.getCurioTags(stack.func_77973_b())) && (Boolean)CuriosAPI.getCurio(stack).map(curio -> curio.canEquip(this.identifier, (LivingEntity)this.player)).orElse((Object)true) != false && super.func_75214_a(stack);
    }

    protected boolean hasValidTag(Set<String> tags) {
        return tags.contains(this.identifier) || tags.contains("curio");
    }

    public boolean func_82869_a(PlayerEntity playerIn) {
        ItemStack stack = this.func_75211_c();
        return (stack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)stack)) && (Boolean)CuriosAPI.getCurio(stack).map(curio -> curio.canUnequip(this.identifier, (LivingEntity)playerIn)).orElse((Object)true) != false && super.func_82869_a(playerIn);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBackgroundSprite() {
        return sprites != null ? sprites.getSpriteForString(this.identifier) : null;
    }

    final class AtlasSpriteHolder {
        private final Map<String, TextureAtlasSprite> spriteMap = new HashMap<String, TextureAtlasSprite>();

        AtlasSpriteHolder() {
        }

        TextureAtlasSprite getSpriteForString(String id) {
            return this.spriteMap.computeIfAbsent(id, key -> new TextureAtlasSprite(SlotCurio.this.backgroundLocation, 16, 16){
                {
                    this.func_217789_a(16, 16, 0, 0);
                }
            });
        }
    }
}

