/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.ICurioItemHandler;
import top.theillusivec4.curios.api.inventory.SlotCurio;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.client.gui.GuiButtonCurios;
import top.theillusivec4.curios.common.CuriosConfig;
import top.theillusivec4.curios.common.inventory.CuriosContainer;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketOpenVanilla;

public class CuriosScreen
extends ContainerScreen<CuriosContainer> {
    static final ResourceLocation CURIO_INVENTORY = new ResourceLocation("curios", "textures/gui/inventory.png");
    static final ResourceLocation RECIPE_BUTTON_TEXTURE = new ResourceLocation("minecraft:textures/gui/recipe_button.png");
    private static final ResourceLocation CREATIVE_INVENTORY_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private boolean widthTooNarrow;
    private float currentScroll;
    private boolean isScrolling;
    private boolean buttonClicked;

    public CuriosScreen(CuriosContainer curiosContainer, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)curiosContainer, playerInventory, title);
        this.passEvents = true;
    }

    public void init() {
        super.init();
        this.widthTooNarrow = this.width < 379;
        this.field_147003_i = (this.width - this.field_146999_f) / 2;
        Tuple<Integer, Integer> offsets = CuriosScreen.getButtonOffset(false);
        this.addButton((Widget)new GuiButtonCurios(this, this.getGuiLeft() + (Integer)offsets.func_76341_a(), this.height / 2 + (Integer)offsets.func_76340_b(), 14, 14, 50, 0, 14, CURIO_INVENTORY));
        if (!this.field_213127_e.field_70458_d.func_184812_l_() && this.minecraft != null) {
            this.addButton((Widget)new ImageButton(this.field_147003_i + 104, this.height / 2 - 22, 20, 18, 0, 0, 19, RECIPE_BUTTON_TEXTURE, button -> {
                Minecraft mc = this.minecraft;
                InventoryScreen inventory = new InventoryScreen((PlayerEntity)mc.field_71439_g);
                ItemStack stack = mc.field_71439_g.field_71071_by.func_70445_o();
                mc.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                mc.func_147108_a((Screen)inventory);
                RecipeBookGui recipeBookGui = inventory.func_194310_f();
                if (!recipeBookGui.func_191878_b()) {
                    recipeBookGui.func_201518_a(inventory.width < 379);
                    recipeBookGui.func_191866_a();
                    ObfuscationReflectionHelper.setPrivateValue(ContainerScreen.class, (Object)inventory, (Object)recipeBookGui.func_193011_a(inventory.width < 379, inventory.width, inventory.getXSize()), (String)"field_147003_i");
                    inventory.children().forEach(listener -> {
                        ImageButton imgButton;
                        ResourceLocation resourceLocation;
                        if (listener instanceof ImageButton && (resourceLocation = (ResourceLocation)ObfuscationReflectionHelper.getPrivateValue(ImageButton.class, (Object)(imgButton = (ImageButton)listener), (String)"field_191750_o")) != null && resourceLocation.equals((Object)RECIPE_BUTTON_TEXTURE)) {
                            imgButton.func_191746_c(inventory.getGuiLeft() + 104, inventory.height / 2 - 22);
                        }
                    });
                }
                mc.field_71439_g.field_71071_by.func_70437_b(stack);
                NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketOpenVanilla());
            }));
        }
    }

    public static Tuple<Integer, Integer> getButtonOffset(boolean isCreative) {
        CuriosConfig.Client client = CuriosConfig.CLIENT;
        CuriosConfig.Client.ButtonCorner corner = (CuriosConfig.Client.ButtonCorner)((Object)client.buttonCorner.get());
        int x = 0;
        int y = 0;
        if (isCreative) {
            x += corner.getCreativeXoffset() + (Integer)client.creativeButtonXOffset.get();
            y += corner.getCreativeYoffset() + (Integer)client.creativeButtonYOffset.get();
        } else {
            x += corner.getXoffset() + (Integer)client.buttonXOffset.get();
            y += corner.getYoffset() + (Integer)client.buttonYOffset.get();
        }
        return new Tuple((Object)x, (Object)y);
    }

    private boolean inScrollBar(double mouseX, double mouseY) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int k = i - 34;
        int l = j + 12;
        int i1 = k + 14;
        int j1 = l + 139;
        return mouseX >= (double)k && mouseY >= (double)l && mouseX < (double)i1 && mouseY < (double)j1;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (KeyRegistry.openCurios.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            this.getMinecraft().field_71439_g.func_71053_j();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        Slot slot;
        this.getMinecraft().field_71466_p.func_211126_b(I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0]), 97.0f, 8.0f, 0x404040);
        if (this.getMinecraft().field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.getSlotUnderMouse() != null && (slot = this.getSlotUnderMouse()) instanceof SlotCurio && !slot.func_75216_d()) {
            SlotCurio slotCurio = (SlotCurio)slot;
            this.renderTooltip(slotCurio.getSlotName(), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(field_147001_a);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        InventoryScreen.func_147046_a((int)(i + 51), (int)(j + 75), (int)30, (float)((float)(i + 51) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (LivingEntity)this.getMinecraft().field_71439_g);
        CuriosAPI.getCuriosHandler((LivingEntity)this.getMinecraft().field_71439_g).ifPresent(handler -> {
            int slotCount = handler.getSlots();
            int upperHeight = 7 + slotCount * 18;
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(CURIO_INVENTORY);
            this.blit(i - 26, j + 4, 0, 0, 27, upperHeight);
            if (slotCount <= 8) {
                this.blit(i - 26, j + 4 + upperHeight, 0, 151, 27, 7);
            } else {
                this.blit(i - 42, j + 4, 27, 0, 23, 158);
                this.getMinecraft().func_110434_K().func_110577_a(CREATIVE_INVENTORY_TABS);
                this.blit(i - 34, j + 12 + (int)(127.0f * this.currentScroll), 232, 0, 12, 15);
            }
        });
    }

    protected boolean func_195359_a(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        return !this.widthTooNarrow && super.func_195359_a(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.inScrollBar(mouseX, mouseY)) {
            this.isScrolling = this.needsScrollBars();
            return true;
        }
        return !this.widthTooNarrow && super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseReleased1, double mouseReleased3, int mouseReleased5) {
        if (mouseReleased5 == 0) {
            this.isScrolling = false;
        }
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.mouseReleased(mouseReleased1, mouseReleased3, mouseReleased5);
    }

    public boolean mouseDragged(double pMouseDragged1, double pMouseDragged3, int pMouseDragged5, double pMouseDragged6, double pMouseDragged8) {
        if (this.isScrolling) {
            int i = this.field_147009_r + 18;
            int j = i + 112;
            this.currentScroll = ((float)pMouseDragged3 - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((CuriosContainer)this.field_147002_h).scrollTo(this.currentScroll);
            return true;
        }
        return super.mouseDragged(pMouseDragged1, pMouseDragged3, pMouseDragged5, pMouseDragged6, pMouseDragged8);
    }

    public boolean mouseScrolled(double pMouseScrolled1, double pMouseScrolled3, double pMouseScrolled5) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = (Integer)((CuriosContainer)this.field_147002_h).curios.map(ICurioItemHandler::getSlots).orElse((Object)1);
        this.currentScroll = (float)((double)this.currentScroll - pMouseScrolled5 / (double)i);
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        ((CuriosContainer)this.field_147002_h).scrollTo(this.currentScroll);
        return true;
    }

    private boolean needsScrollBars() {
        return ((CuriosContainer)this.field_147002_h).canScroll();
    }
}

