/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import top.theillusivec4.curios.common.CuriosConfig;

public class CuriosLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    public CuriosLayer(IEntityRenderer<T, M> renderer) {
        super(renderer);
    }

    public void render(@Nonnull LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!((Boolean)CuriosConfig.CLIENT.renderCurios.get()).booleanValue()) {
            return;
        }
        GlStateManager.pushMatrix();
        CuriosAPI.getCuriosHandler(livingEntity).ifPresent(handler -> {
            SortedMap<String, CurioStackHandler> curios = handler.getCurioMap();
            if (livingEntity.func_213287_bg()) {
                GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.0f);
            }
            for (String id : curios.keySet()) {
                CurioStackHandler stackHandler = (CurioStackHandler)((Object)((Object)curios.get(id)));
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    CuriosAPI.getCurio(stack).ifPresent(curio -> {
                        if (curio.hasRender(id, livingEntity)) {
                            GlStateManager.pushMatrix();
                            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            curio.doRender(id, livingEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                            GlStateManager.popMatrix();
                        }
                    });
                }
            }
        });
        GlStateManager.popMatrix();
    }

    public boolean func_177142_b() {
        return false;
    }
}

