/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class SPacketSyncOperation {
    private int entityId;
    private String curioId;
    private int operation;
    private int amount;
    private boolean visible;
    private boolean cosmetic;

    public SPacketSyncOperation(int entityId, String curioId, Operation operation) {
        this(entityId, curioId, operation, 0);
    }

    public SPacketSyncOperation(int entityId, String curioId, Operation operation, int amount) {
        this(entityId, curioId, operation, amount, true, false);
    }

    public SPacketSyncOperation(int entityId, String curioId, Operation operation, int amount, boolean visible, boolean cosmetic) {
        this.entityId = entityId;
        this.curioId = curioId;
        this.amount = amount;
        this.operation = operation.ordinal();
        this.visible = visible;
        this.cosmetic = cosmetic;
    }

    public static void encode(SPacketSyncOperation msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_180714_a(msg.curioId);
        buf.writeInt(msg.operation);
        buf.writeInt(msg.amount);
        buf.writeBoolean(msg.visible);
        buf.writeBoolean(msg.cosmetic);
    }

    public static SPacketSyncOperation decode(PacketBuffer buf) {
        return new SPacketSyncOperation(buf.readInt(), buf.func_150789_c(25), Operation.fromValue(buf.readInt()), buf.readInt(), buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(SPacketSyncOperation msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (entity = world.func_73045_a(msg.entityId)) instanceof LivingEntity) {
                CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)entity).ifPresent(handler -> {
                    Operation op = Operation.fromValue(msg.operation);
                    String id = msg.curioId;
                    int amount = msg.amount;
                    switch (op) {
                        case GROW: {
                            handler.growSlotType(id, amount);
                            break;
                        }
                        case SHRINK: {
                            handler.shrinkSlotType(id, amount);
                            break;
                        }
                        case LOCK: {
                            handler.lockSlotType(id);
                            break;
                        }
                        case UNLOCK: {
                            handler.unlockSlotType(id, amount, msg.visible, msg.cosmetic);
                        }
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Operation {
        LOCK,
        UNLOCK,
        SHRINK,
        GROW;


        public static Operation fromValue(int value) {
            try {
                return Operation.values()[value];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unknown operation value: " + value);
            }
        }
    }
}

