/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.property;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ExtendedBlockStateBuilder {
    private final IExtendedBlockState defaultBlockState;
    private final Map<IProperty<?>, Comparable<?>> properties;
    private final Map<IUnlistedProperty<?>, Optional<?>> unlistedProperties;

    protected ExtendedBlockStateBuilder(IExtendedBlockState defaultBlockState) {
        this.properties = Maps.newHashMap((Map)defaultBlockState.func_177228_b());
        this.unlistedProperties = Maps.newHashMap((Map)defaultBlockState.getUnlistedProperties());
        this.defaultBlockState = defaultBlockState;
    }

    public <T extends Comparable<T>, V extends T> ExtendedBlockStateBuilder withProperty(IProperty<T> property, V value) {
        if (!this.properties.containsKey(property)) {
            throw new IllegalArgumentException("Cannot set property " + property + " as it does not exist in " + this.getBlock().func_176194_O());
        }
        if (!property.func_177700_c().contains(value)) {
            throw new IllegalArgumentException("Cannot set property " + property + " to " + value + " on block " + Block.field_149771_c.func_177774_c((Object)this.getBlock()) + ", it is not an allowed value");
        }
        this.properties.put(property, (Comparable<?>)value);
        return this;
    }

    public <V> ExtendedBlockStateBuilder withProperty(IUnlistedProperty<V> property, V value) {
        if (!this.unlistedProperties.containsKey(property)) {
            throw new IllegalArgumentException("Cannot set unlisted property " + property + " as it does not exist in " + this.getBlock().func_176194_O());
        }
        if (!property.isValid(value)) {
            throw new IllegalArgumentException("Cannot set unlisted property " + property + " to " + value + " on block " + Block.field_149771_c.func_177774_c((Object)this.getBlock()) + ", it is not an allowed value");
        }
        if (this.unlistedProperties.get(property) == value) {
            return this;
        }
        this.unlistedProperties.put(property, Optional.fromNullable(value));
        return this;
    }

    protected Block getBlock() {
        return this.defaultBlockState.func_177230_c();
    }

    public IExtendedBlockState build() {
        return new BuiltExtendedBlockState(this.getBlock(), ImmutableMap.copyOf(this.properties), ImmutableMap.copyOf(this.unlistedProperties), null);
    }

    public static ExtendedBlockStateBuilder builder(IExtendedBlockState defaultBlockState) {
        return new ExtendedBlockStateBuilder(defaultBlockState);
    }

    public class BuiltExtendedBlockState
    extends BlockStateContainer.StateImplementation
    implements IExtendedBlockState {
        private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;
        private Map<Map<IProperty<?>, Comparable<?>>, BlockStateContainer.StateImplementation> normalMap;

        protected BuiltExtendedBlockState(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> table) {
            super(block, properties);
            this.unlistedProperties = unlistedProperties;
            this.field_177238_c = table;
        }

        public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(IProperty<T> property, V value) {
            throw new UnsupportedOperationException("Can't set property on built blockstate");
        }

        public <V> IExtendedBlockState withProperty(IUnlistedProperty<V> property, V value) {
            throw new UnsupportedOperationException("Can't set unlisted property on built blockstate");
        }

        public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
            return this.unlistedProperties;
        }

        public void func_177235_a(Map<Map<IProperty<?>, Comparable<?>>, BlockStateContainer.StateImplementation> map) {
            this.normalMap = map;
            super.func_177235_a(map);
        }

        public IBlockState getClean() {
            return (IBlockState)this.normalMap.get(this.func_177228_b());
        }

        public Collection<IUnlistedProperty<?>> getUnlistedNames() {
            return Collections.unmodifiableCollection(this.unlistedProperties.keySet());
        }

        public <V> V getValue(IUnlistedProperty<V> property) {
            Optional value = (Optional)this.unlistedProperties.get(property);
            if (value == null) {
                throw new IllegalArgumentException("Cannot get unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
            }
            return (V)property.getType().cast(value.orNull());
        }
    }
}

