/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;

public class GuiHandler
implements IGuiHandler {
    private final ModBase mod;
    private Map<Integer, Class<? extends Container>> containers = Maps.newHashMap();
    private Map<Integer, Class<? extends GuiScreen>> guis = Maps.newHashMap();
    private Map<Integer, GuiType> types = Maps.newHashMap();
    private Map<GuiType, Object> tempDataHolderClient = Maps.newHashMap();
    private Map<GuiType, Object> tempDataHolderServer = Maps.newHashMap();

    public GuiHandler(ModBase mod) {
        this.mod = mod;
    }

    public ModBase getMod() {
        return this.mod;
    }

    public void registerGUI(IGuiContainerProvider guiProvider, GuiType type) {
        this.containers.put(guiProvider.getGuiID(), guiProvider.getContainer());
        if (MinecraftHelpers.isClientSide()) {
            this.guis.put(guiProvider.getGuiID(), guiProvider.getGui());
        }
        this.types.put(guiProvider.getGuiID(), type);
    }

    public <O> void setTemporaryData(GuiType<O> guiType, O data) {
        if (MinecraftHelpers.isClientSide()) {
            this.tempDataHolderClient.put(guiType, data);
        } else {
            this.tempDataHolderServer.put(guiType, data);
        }
    }

    private <O> void clearTemporaryData(GuiType<O> guiType) {
        this.setTemporaryData(guiType, null);
    }

    private <O> O getTemporaryData(GuiType<O> guiType) throws IllegalArgumentException {
        Object data = MinecraftHelpers.isClientSide() ? this.tempDataHolderClient.get(guiType) : this.tempDataHolderServer.get(guiType);
        this.clearTemporaryData(guiType);
        if (guiType.isCarriesData() && data == null) {
            throw new IllegalArgumentException("Invalid GUI data.");
        }
        return (O)data;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Class<? extends Container> containerClass = this.containers.get(id);
        if (containerClass == null) {
            return null;
        }
        GuiType guiType = this.types.get(id);
        return guiType.getContainerConstructor().getServerGuiElement(id, player, world, x, y, z, containerClass, this.getTemporaryData(guiType));
    }

    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Class<? extends GuiScreen> guiClass = this.guis.get(id);
        GuiType guiType = this.types.get(id);
        return guiType.getGuiConstructor().getClientGuiElement(id, player, world, x, y, z, guiClass, this.getTemporaryData(guiType));
    }

    public static interface IGuiConstructor<O> {
        public Object getClientGuiElement(int var1, EntityPlayer var2, World var3, int var4, int var5, int var6, Class<? extends GuiScreen> var7, O var8);
    }

    public static interface IContainerConstructor<O> {
        public Object getServerGuiElement(int var1, EntityPlayer var2, World var3, int var4, int var5, int var6, Class<? extends Container> var7, O var8);
    }

    public static class GuiType<O> {
        private final boolean carriesData;
        private IContainerConstructor<O> containerConstructor = null;
        private IGuiConstructor<O> guiConstructor = null;
        public static final GuiType<Void> BLOCK = GuiType.create(false);
        public static final GuiType<Void> TILE = GuiType.create(false);
        public static final GuiType<Integer> ITEM = GuiType.create(true);

        private GuiType(boolean carriesData) {
            this.carriesData = carriesData;
        }

        public boolean isCarriesData() {
            return this.carriesData;
        }

        public void setContainerConstructor(IContainerConstructor<O> containerConstructor) {
            if (this.containerConstructor != null) {
                throw new IllegalStateException("The container constructor was already set!");
            }
            this.containerConstructor = containerConstructor;
        }

        @SideOnly(value=Side.CLIENT)
        public void setGuiConstructor(IGuiConstructor<O> guiConstructor) {
            if (this.guiConstructor != null) {
                throw new IllegalStateException("The gui constructor was already set!");
            }
            this.guiConstructor = guiConstructor;
        }

        public IContainerConstructor<O> getContainerConstructor() {
            return this.containerConstructor;
        }

        @SideOnly(value=Side.CLIENT)
        public IGuiConstructor<O> getGuiConstructor() {
            return this.guiConstructor;
        }

        public static <O> GuiType<O> create(boolean carriesData) {
            return new GuiType<O>(carriesData);
        }

        static {
            BLOCK.setContainerConstructor(new IContainerConstructor<Void>(){

                @Override
                public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z, Class<? extends Container> containerClass, Void data) {
                    try {
                        Constructor<? extends Container> containerConstructor = containerClass.getConstructor(InventoryPlayer.class);
                        return containerConstructor.newInstance(player.field_71071_by);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        try {
                            Constructor<? extends Container> containerConstructor = containerClass.getConstructor(InventoryPlayer.class, World.class, BlockPos.class);
                            return containerConstructor.newInstance(player.field_71071_by, world, new BlockPos(x, y, z));
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                            e2.printStackTrace();
                            return null;
                        }
                    }
                }
            });
            TILE.setContainerConstructor(new IContainerConstructor<Void>(){

                @Override
                public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z, Class<? extends Container> containerClass, Void data) {
                    try {
                        TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
                        Constructor<? extends Container> containerConstructor = containerClass.getConstructor(InventoryPlayer.class, tileEntity.getClass());
                        return containerConstructor.newInstance(player.field_71071_by, tileEntity);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
            ITEM.setContainerConstructor(new IContainerConstructor<Integer>(){

                @Override
                public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z, Class<? extends Container> containerClass, Integer data) {
                    try {
                        Constructor<? extends Container> containerConstructor = containerClass.getConstructor(EntityPlayer.class, Integer.TYPE);
                        return containerConstructor.newInstance(player, data);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
            if (MinecraftHelpers.isClientSide()) {
                BLOCK.setGuiConstructor(new IGuiConstructor<Void>(){

                    @Override
                    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z, Class<? extends GuiScreen> guiClass, Void data) {
                        try {
                            Constructor<? extends GuiScreen> guiConstructor = guiClass.getConstructor(InventoryPlayer.class);
                            return guiConstructor.newInstance(player.field_71071_by);
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            try {
                                Constructor<? extends GuiScreen> guiConstructor = guiClass.getConstructor(InventoryPlayer.class, World.class, BlockPos.class);
                                return guiConstructor.newInstance(player.field_71071_by, world, new BlockPos(x, y, z));
                            }
                            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                                e2.printStackTrace();
                                return null;
                            }
                        }
                    }
                });
                TILE.setGuiConstructor(new IGuiConstructor<Void>(){

                    @Override
                    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z, Class<? extends GuiScreen> guiClass, Void data) {
                        try {
                            TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
                            Constructor<? extends GuiScreen> guiConstructor = guiClass.getConstructor(InventoryPlayer.class, tileEntity.getClass());
                            return guiConstructor.newInstance(player.field_71071_by, tileEntity);
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                });
                ITEM.setGuiConstructor(new IGuiConstructor<Integer>(){

                    @Override
                    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z, Class<? extends GuiScreen> guiClass, Integer data) {
                        try {
                            Constructor<? extends GuiScreen> guiConstructor = guiClass.getConstructor(EntityPlayer.class, Integer.TYPE);
                            return guiConstructor.newInstance(player, data);
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                });
            }
        }
    }
}

