/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.cyclops.cyclopscore.command.CommandConfig;
import org.cyclops.cyclopscore.command.CommandVersion;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;

public class CommandMod
implements ICommand {
    private final ModBase mod;
    private final Map<String, ICommand> subCommands;
    private final List<String> aliases = Lists.newLinkedList();

    public CommandMod(ModBase mod, Map<String, ICommand> subCommands) {
        this.mod = mod;
        this.subCommands = subCommands;
        this.subCommands.put("config", new CommandConfig(mod));
        this.subCommands.put("version", new CommandVersion(mod));
        this.addAlias(mod.getModId());
    }

    public CommandMod(ModBase mod) {
        this.mod = mod;
        this.subCommands = Maps.newHashMap();
    }

    public CommandMod(ModBase mod, String name) {
        this(mod);
        this.addAlias(name);
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    protected ModBase getMod() {
        return this.mod;
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    protected Map<String, ICommand> getSubcommands() {
        return this.subCommands;
    }

    private List<String> getSubCommands(String cmd) {
        LinkedList<String> completions = new LinkedList<String>();
        for (String full : this.getSubcommands().keySet()) {
            if (!full.startsWith(cmd)) continue;
            completions.add(full);
        }
        return completions;
    }

    public int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }

    public String func_71517_b() {
        return this.mod.getModId();
    }

    public String getFullCommand() {
        return this.func_71517_b();
    }

    public String func_71518_a(ICommandSender icommandsender) {
        String command = "/" + this.getFullCommand();
        Iterator<String> it = this.getSubcommands().keySet().iterator();
        return it.hasNext() ? this.joinStrings(command + " <", it, " | ", ">") : command;
    }

    protected String[] shortenArgumentList(String[] astring) {
        String[] asubstring = new String[astring.length - 1];
        System.arraycopy(astring, 1, asubstring, 0, astring.length - 1);
        return asubstring;
    }

    public void processCommandHelp(ICommandSender icommandsender, String[] astring) throws CommandException {
        throw new WrongUsageException(this.func_71518_a(icommandsender), new Object[0]);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender icommandsender, String[] astring) throws CommandException {
        if (astring.length == 0) {
            this.processCommandHelp(icommandsender, astring);
        } else {
            ICommand subcommand = this.getSubcommands().get(astring[0]);
            if (subcommand != null) {
                String[] asubstring = this.shortenArgumentList(astring);
                subcommand.func_184881_a(server, icommandsender, asubstring);
            } else {
                throw new WrongUsageException(L10NHelpers.localize("chat.cyclopscore.command.invalidSubcommand", new Object[0]), new Object[0]);
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender icommandsender) {
        return icommandsender.func_70003_b(FMLCommonHandler.instance().getMinecraftServerInstance().func_110455_j(), this.func_71517_b());
    }

    public List func_184883_a(MinecraftServer server, ICommandSender icommandsender, String[] astring, BlockPos blockPos) {
        if (astring.length != 0) {
            ICommand subcommand = this.getSubcommands().get(astring[0]);
            if (subcommand != null) {
                String[] asubstring = this.shortenArgumentList(astring);
                return subcommand.func_184883_a(server, icommandsender, asubstring, blockPos);
            }
            return this.getSubCommands(astring[0]);
        }
        return this.getSubCommands("");
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }

    protected String joinStrings(Iterator<String> it, String delim) {
        return this.joinStrings("", it, delim, "");
    }

    protected String joinStrings(String prefix, Iterator<String> it, String delim, String suffix) {
        StringBuilder builder = new StringBuilder(prefix);
        if (it.hasNext()) {
            builder.append(it.next());
            while (it.hasNext()) {
                builder.append(delim);
                builder.append(it.next());
            }
        }
        builder.append(suffix);
        return builder.toString();
    }

    protected void printLineToChat(ICommandSender sender, String line) {
        sender.func_145747_a((ITextComponent)new TextComponentString(line));
    }
}

