/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigProperty;
import org.cyclops.cyclopscore.config.ConfigPropertyCallback;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.CyclopsCoreConfigException;
import org.cyclops.cyclopscore.config.IChangedCallback;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class ExtendedConfig<C extends ExtendedConfig<C>>
implements Comparable<ExtendedConfig<C>>,
IInitListener {
    private final ModBase mod;
    private boolean enabled;
    private final String namedId;
    private final String comment;
    private final Class element;
    private IConfigurable overriddenSubInstance;
    public List<ConfigProperty> configProperties = Lists.newLinkedList();

    public ExtendedConfig(ModBase mod, boolean enabled, String namedId, String comment, Class<?> element) {
        this.mod = mod;
        this.enabled = enabled;
        this.namedId = namedId.toLowerCase(Locale.ROOT);
        this.comment = comment;
        this.element = element;
        try {
            this.generateConfigProperties();
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
    }

    private void generateConfigProperties() throws IllegalArgumentException, IllegalAccessException {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigurableProperty.class)) continue;
            ConfigurableProperty annotation = field.getAnnotation(ConfigurableProperty.class);
            IChangedCallback changedCallback = null;
            if (annotation.changedCallback() != IChangedCallback.class) {
                try {
                    changedCallback = annotation.changedCallback().newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            String category = annotation.categoryRaw().equals("") ? annotation.category().toString() : annotation.categoryRaw();
            ConfigProperty configProperty = new ConfigProperty(this.getMod(), category, this.getConfigPropertyPrefix() + "." + field.getName(), field.get(null), annotation.comment(), new ConfigPropertyCallback(changedCallback), annotation.isCommandable(), field);
            configProperty.setRequiresWorldRestart(annotation.requiresWorldRestart());
            configProperty.setRequiresMcRestart(annotation.requiresMcRestart());
            configProperty.setShowInGui(annotation.showInGui());
            configProperty.setMinValue(annotation.minimalValue());
            configProperty.setMaxValue(annotation.maximalValue());
            this.configProperties.add(configProperty);
        }
    }

    protected String getConfigPropertyPrefix() {
        return this.getNamedId();
    }

    public void save() {
        try {
            try {
                this.getClass().getField("_instance").set(null, this);
            }
            catch (NoSuchFieldError e) {
                throw new CyclopsCoreConfigException(String.format("The config file for %s requires a static field _instance.", this.getNamedId()));
            }
            this.overriddenSubInstance = this.initSubInstance();
            if (this.getOverriddenSubInstance() == null && this.getHolderType().hasUniqueInstance()) {
                Constructor constructor = this.getElement().getDeclaredConstructor(ExtendedConfig.class);
                if (constructor == null) {
                    throw new CyclopsCoreConfigException(String.format("The class %s requires a constructor with ExtendedConfig as single parameter.", this.getElement()));
                }
                Object instance = constructor.newInstance(this);
                Field field = this.getElement().getDeclaredField("_instance");
                field.setAccessible(true);
                if (field.get(null) == null) {
                    field.set(null, instance);
                } else {
                    this.showDoubleInitError();
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | RuntimeException e) {
            this.mod.getLoggerHelper().getLogger().error(String.format("Registering %s caused an issue. ", this.getNamedId()), (Throwable)e);
            throw new CyclopsCoreConfigException(String.format("Registering %s caused the issue: %s", this.getNamedId(), e.getMessage()));
        }
        catch (InvocationTargetException e) {
            this.mod.log(Level.ERROR, "Registering " + this.getNamedId() + " caused the issue (skipping registration): " + e.getCause().getMessage());
            this.mod.getLoggerHelper().getLogger().error("Registering %s caused an issue. ", e.getCause());
            if (!this.isDisableable()) {
                throw new CyclopsCoreConfigException("Registering " + this.getNamedId() + " caused the issue: " + e.getCause().getMessage() + ". Since this is a required element of this mod, we can not continue, there might be ID conflicts with other mods.");
            }
            this.setEnabled(false);
        }
    }

    public abstract ConfigurableType getHolderType();

    public abstract String getUnlocalizedName();

    public String getFullUnlocalizedName() {
        return this.getUnlocalizedName();
    }

    protected IConfigurable initSubInstance() {
        return null;
    }

    private IConfigurable getOverriddenSubInstance() {
        return this.overriddenSubInstance;
    }

    public IConfigurable getSubInstance() {
        if (this.getOverriddenSubInstance() != null) {
            return this.getOverriddenSubInstance();
        }
        if (!this.getHolderType().hasUniqueInstance()) {
            throw new CyclopsCoreConfigException("There exists no unique instance for " + this);
        }
        try {
            Method method = this.getElement().getMethod("getInstance", new Class[0]);
            if (method == null) {
                throw new CyclopsCoreConfigException("There exists no static getInstance method for  " + this);
            }
            return (IConfigurable)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public String getSubUniqueName() {
        return this.getNamedId();
    }

    public void onRegistered() {
    }

    @Override
    public void onInit(IInitListener.Step step) {
    }

    @Override
    public int compareTo(ExtendedConfig<C> o) {
        return this.getNamedId().compareTo(o.getNamedId());
    }

    public boolean isEnabled() {
        return this.enabled && !this.isHardDisabled();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isHardDisabled() {
        return false;
    }

    public boolean isDisableable() {
        return true;
    }

    public void showDoubleInitError() {
        String message = this.getClass() + " caused a double registration of " + this.getSubInstance() + ". This is an error in the mod code.";
        this.mod.log(Level.FATAL, message);
        throw new CyclopsCoreConfigException(message);
    }

    public C downCast() {
        return (C)this;
    }

    public ModBase getMod() {
        return this.mod;
    }

    public String getNamedId() {
        return this.namedId;
    }

    public String getComment() {
        return this.comment;
    }

    public Class getElement() {
        return this.element;
    }
}

