/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class EnchantmentHelpers {
    public static int doesEnchantApply(ItemStack itemStack, Enchantment enchantment) {
        NBTTagList enchantmentList;
        if (itemStack != null && (enchantmentList = itemStack.func_77986_q()) != null) {
            for (int i = 0; i < enchantmentList.func_74745_c(); ++i) {
                if (enchantmentList.func_150305_b(i).func_74765_d("id") != Enchantment.func_185258_b((Enchantment)enchantment)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getEnchantmentLevel(ItemStack itemStack, int enchantmentListID) {
        NBTTagList enchlist = itemStack.func_77986_q();
        return enchlist.func_150305_b(enchantmentListID).func_74765_d("lvl");
    }

    public static int getEnchantmentID(ItemStack itemStack, int enchantmentListID) {
        NBTTagList enchlist = itemStack.func_77986_q();
        return enchlist.func_150305_b(enchantmentListID).func_74765_d("id");
    }

    public static void setEnchantmentLevel(ItemStack itemStack, int enchantmentListID, int level) {
        NBTTagList enchlist = itemStack.func_77986_q();
        if (level <= 0) {
            enchlist.func_74744_a(enchantmentListID);
            if (enchlist.func_74745_c() == 0) {
                itemStack.func_77978_p().func_82580_o("ench");
            }
        } else {
            NBTTagCompound compound = enchlist.func_150305_b(enchantmentListID);
            compound.func_74777_a("lvl", (short)level);
        }
    }

    public static void setEnchantmentLevel(ItemStack itemStack, Enchantment enchantment, int level) {
        NBTTagList enchlist = itemStack.func_77986_q();
        if (level <= 0 || enchlist != null) {
            EnchantmentHelpers.setEnchantmentLevel(itemStack, Enchantment.func_185258_b((Enchantment)enchantment), level);
        } else {
            itemStack.func_77966_a(enchantment, level);
        }
    }
}

