/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class InventoryHelpers {
    public static void clearInventory(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public static void tryReAddToStack(EntityPlayer player, @Nullable ItemStack originalStack, ItemStack newStackPart) {
        if (!player.field_71075_bZ.field_75098_d) {
            if (originalStack != null && originalStack.func_190916_E() - 1 == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newStackPart);
            } else {
                if (originalStack != null) {
                    originalStack.func_190918_g(1);
                }
                if (!player.field_71071_by.func_70441_a(newStackPart)) {
                    player.func_71019_a(newStackPart, false);
                }
            }
        }
    }

    public static void validateNBTStorage(IInventory inventory, ItemStack itemStack, String tagName) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        if (!tag.func_74764_b(tagName)) {
            tag.func_74782_a(tagName, (NBTBase)new NBTTagList());
        }
        InventoryHelpers.readFromNBT(inventory, tag, tagName);
    }

    public static void readFromNBT(IInventory inventory, NBTTagCompound data, String tagName) {
        int j;
        NBTTagList nbttaglist = data.func_150295_c(tagName, MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        for (j = 0; j < inventory.func_70302_i_(); ++j) {
            inventory.func_70299_a(j, ItemStack.field_190927_a);
        }
        for (j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound slot = nbttaglist.func_150305_b(j);
            int index = slot.func_74764_b("index") ? slot.func_74762_e("index") : (int)slot.func_74771_c("Slot");
            if (index < 0 || index >= inventory.func_70302_i_()) continue;
            inventory.func_70299_a(index, new ItemStack(slot));
        }
    }

    public static void writeToNBT(IInventory inventory, NBTTagCompound data, String tagName) {
        NBTTagList slots = new NBTTagList();
        for (int index = 0; index < inventory.func_70302_i_(); index = (int)((byte)(index + 1))) {
            ItemStack itemStack = inventory.func_70301_a(index);
            if (itemStack.func_190926_b() || itemStack.func_190916_E() <= 0) continue;
            NBTTagCompound slot = new NBTTagCompound();
            slot.func_74768_a("index", index);
            slots.func_74742_a((NBTBase)slot);
            itemStack.func_77955_b(slot);
        }
        data.func_74782_a(tagName, (NBTBase)slots);
    }

    public static ItemStack getItemFromIndex(EntityPlayer player, int itemIndex) {
        return (ItemStack)player.field_71071_by.field_70462_a.get(itemIndex);
    }

    public static boolean addToSlot(IInventory inventory, int slot, ItemStack itemStack) {
        return InventoryHelpers.addToSlot(inventory, slot, itemStack, false);
    }

    public static boolean addToSlot(IInventory inventory, int slot, ItemStack itemStack, boolean simulate) {
        ItemStack produceStack = inventory.func_70301_a(slot);
        if (produceStack.func_190926_b()) {
            inventory.func_70299_a(slot, itemStack);
            return true;
        }
        if (produceStack.func_77973_b() == itemStack.func_77973_b() && produceStack.func_77976_d() >= produceStack.func_190916_E() + itemStack.func_190916_E()) {
            if (!simulate) {
                produceStack.func_190917_f(itemStack.func_190916_E());
            }
            return true;
        }
        return false;
    }
}

