/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.init.ModBase;

public class InfoSectionTagIndex
extends InfoSection {
    public InfoSectionTagIndex(IInfoBook infoBook, InfoSection parent) {
        super(infoBook, parent, parent.getSubSections(), "info_book." + infoBook.getMod().getModId() + ".tag_index", new ArrayList<String>(), new ArrayList<SectionAppendix>(), new ArrayList<String>());
        infoBook.setConfigLinks(Maps.newTreeMap((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return L10NHelpers.localize(o1, new Object[0]).compareTo(L10NHelpers.localize(o2, new Object[0]));
            }
        }));
    }

    @Override
    public void bakeSection(FontRenderer fontRenderer, int width, int maxLines, int lineHeight, int yOffset) {
        if (this.paragraphs.size() == 0) {
            this.addLinks(maxLines, lineHeight, yOffset, this.getInfoBook().getConfigLinks());
        }
        super.bakeSection(fontRenderer, width, maxLines, lineHeight, yOffset);
    }

    @Override
    protected boolean shouldAddIndex() {
        return false;
    }

    public void addSoftLinks(InfoSection section) {
        Map<String, Pair<InfoSection, Integer>> softLinks = this.getInfoBook().getConfigLinks();
        for (String tag : section.getTags()) {
            ModBase mod = this.getInfoBook().getMod();
            if (tag.contains(":")) {
                String[] split = tag.split(":");
                mod = ModBase.get(split[0]);
                tag = split[1];
            }
            if (softLinks.containsKey(tag)) {
                throw new IllegalArgumentException("The tag " + tag + " occurs multiple times.");
            }
            ExtendedConfig config = mod.getConfigHandler().getDictionary().get(tag);
            if (config == null) continue;
            softLinks.put(config.getFullUnlocalizedName(), (Pair<InfoSection, Integer>)Pair.of((Object)section, (Object)0));
        }
        for (int i = 0; i < section.getSubSections(); ++i) {
            this.addSoftLinks(section.getSubSection(i));
        }
    }
}

