/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;
import org.cyclops.cyclopscore.network.packet.AchievementRewardsObtainPacket;

public class AchievementRewards {
    private static final Map<String, AchievementRewards> ACHIEVEMENT_REWARDS = Maps.newHashMap();
    public static String NBT_KEY_OBTAINED_PREFIX = "cyclopscore:obtainedAchievements:";
    private final String id;
    private final List<Achievement> achievements;
    private final List<IReward> rewards;

    public AchievementRewards(String id, List<Achievement> achievements, List<IReward> rewards) {
        this.id = id;
        this.achievements = achievements;
        this.rewards = rewards;
        if (ACHIEVEMENT_REWARDS.put(id, this) != null) {
            throw new IllegalArgumentException(String.format("Duplicate achievement rewards id '%s' was found.", id));
        }
    }

    public static AchievementRewards getAchievementRewards(String achievementRewardsId) {
        return ACHIEVEMENT_REWARDS.get(achievementRewardsId);
    }

    protected String getNbtTagKey() {
        return NBT_KEY_OBTAINED_PREFIX + this.id;
    }

    public boolean isObtained(EntityPlayer player) {
        return EntityHelpers.getPersistedPlayerNbt(player).func_74767_n(this.getNbtTagKey());
    }

    public void obtain(EntityPlayer player) {
        if (!this.isObtained(player)) {
            if (MinecraftHelpers.isClientSide()) {
                CyclopsCore._instance.getPacketHandler().sendToServer(new AchievementRewardsObtainPacket(this.id));
            } else {
                for (IReward reward : this.getRewards()) {
                    reward.obtain(player);
                }
            }
            NBTTagCompound tag = player.getEntityData();
            if (!tag.func_74764_b("PlayerPersisted")) {
                tag.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
            }
            NBTTagCompound persistedTag = tag.func_74775_l("PlayerPersisted");
            persistedTag.func_74757_a(this.getNbtTagKey(), true);
        }
    }

    public String getId() {
        return this.id;
    }

    public List<Achievement> getAchievements() {
        return this.achievements;
    }

    public List<IReward> getRewards() {
        return this.rewards;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AchievementRewards)) {
            return false;
        }
        AchievementRewards other = (AchievementRewards)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<Achievement> this$achievements = this.getAchievements();
        List<Achievement> other$achievements = other.getAchievements();
        if (this$achievements == null ? other$achievements != null : !((Object)this$achievements).equals(other$achievements)) {
            return false;
        }
        List<IReward> this$rewards = this.getRewards();
        List<IReward> other$rewards = other.getRewards();
        return !(this$rewards == null ? other$rewards != null : !((Object)this$rewards).equals(other$rewards));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AchievementRewards;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        List<Achievement> $achievements = this.getAchievements();
        result = result * 59 + ($achievements == null ? 0 : ((Object)$achievements).hashCode());
        List<IReward> $rewards = this.getRewards();
        result = result * 59 + ($rewards == null ? 0 : ((Object)$rewards).hashCode());
        return result;
    }

    public String toString() {
        return "AchievementRewards(id=" + this.getId() + ", achievements=" + this.getAchievements() + ", rewards=" + this.getRewards() + ")";
    }
}

