/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.GuiInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.lwjgl.opengl.GL11;

public abstract class RecipeAppendix<T>
extends SectionAppendix {
    protected static final int SLOT_SIZE = 16;
    protected static final int TICK_DELAY = 30;
    protected T recipe;
    protected Map<AdvancedButton.Enum, AdvancedButton> renderItemHolders = Maps.newHashMap();

    public RecipeAppendix(IInfoBook infoBook, T recipe) {
        super(infoBook);
        this.recipe = recipe;
    }

    protected int getTick(GuiInfoBook gui) {
        return gui.getTick() / 30;
    }

    protected ItemStack prepareItemStacks(List<ItemStack> itemStacks, int tick) {
        if (itemStacks.size() == 0) {
            return ItemStack.field_190927_a;
        }
        return this.prepareItemStack(itemStacks.get(tick % itemStacks.size()).func_77946_l(), tick);
    }

    protected ItemStack prepareItemStack(ItemStack itemStack, int tick) {
        if (itemStack.func_77952_i() == Short.MAX_VALUE) {
            NonNullList itemStacks = NonNullList.func_191196_a();
            itemStack.func_77973_b().func_150895_a(itemStack.func_77973_b(), null, itemStacks);
            if (itemStacks.isEmpty()) {
                return itemStack;
            }
            return (ItemStack)itemStacks.get(tick % itemStacks.size());
        }
        return itemStack;
    }

    protected void renderItem(GuiInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my, AdvancedButton.Enum buttonEnum) {
        this.renderItem(gui, x, y, itemStack, mx, my, true, buttonEnum);
    }

    protected void renderItem(GuiInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, AdvancedButton.Enum buttonEnum) {
        RecipeAppendix.renderItemForButton(gui, x, y, itemStack, mx, my, renderOverlays, buttonEnum != null ? (ItemButton)this.renderItemHolders.get(buttonEnum) : null);
    }

    public static void renderItemForButton(GuiInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, ItemButton button) {
        if (renderOverlays) {
            gui.drawOuterBorder(x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (itemStack != null) {
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            GL11.glEnable((int)2929);
            renderItem.func_180450_b(itemStack, x, y);
            if (renderOverlays) {
                renderItem.func_175030_a(Minecraft.func_71410_x().field_71466_p, itemStack, x, y);
            }
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
            GL11.glDisable((int)2929);
            if (button != null && renderOverlays) {
                button.update(x, y, itemStack, gui);
            }
        }
    }

    protected void renderFluid(GuiInfoBook gui, int x, int y, FluidStack fluidStack, int mx, int my, AdvancedButton.Enum buttonEnum) {
        this.renderFluid(gui, x, y, fluidStack, mx, my, true, buttonEnum);
    }

    protected void renderFluid(GuiInfoBook gui, int x, int y, FluidStack fluidStack, int mx, int my, boolean renderOverlays, AdvancedButton.Enum buttonEnum) {
        RecipeAppendix.renderFluidForButton(gui, x, y, fluidStack, mx, my, renderOverlays, buttonEnum != null ? (FluidButton)this.renderItemHolders.get(buttonEnum) : null);
    }

    public static void renderFluidForButton(GuiInfoBook gui, int x, int y, FluidStack fluidStack, int mx, int my, boolean renderOverlays, FluidButton button) {
        if (renderOverlays) {
            gui.drawOuterBorder(x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (fluidStack != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            GL11.glEnable((int)2929);
            GlStateManager.func_179094_E();
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            textureManager.func_110577_a(TextureMap.field_110575_b);
            textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon(fluidStack, EnumFacing.UP);
            VertexBuffer worldRenderer = Tessellator.func_178181_a().func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            float minX = x;
            float minY = y;
            float maxX = minX + 16.0f;
            float maxY = minY + 16.0f;
            float u1 = icon.func_94209_e();
            float u2 = icon.func_94212_f();
            float v1 = icon.func_94206_g();
            float v2 = icon.func_94210_h();
            Triple<Float, Float, Float> colorParts = RenderHelpers.getFluidVertexBufferColor(fluidStack);
            float r = ((Float)colorParts.getLeft()).floatValue();
            float g = ((Float)colorParts.getMiddle()).floatValue();
            float b = ((Float)colorParts.getRight()).floatValue();
            worldRenderer.func_181662_b((double)maxX, (double)maxY, 0.0).func_187315_a((double)u2, (double)v2).func_181666_a(r, g, b, 1.0f).func_181675_d();
            worldRenderer.func_181662_b((double)maxX, (double)minY, 0.0).func_187315_a((double)u2, (double)v1).func_181666_a(r, g, b, 1.0f).func_181675_d();
            worldRenderer.func_181662_b((double)minX, (double)minY, 0.0).func_187315_a((double)u1, (double)v1).func_181666_a(r, g, b, 1.0f).func_181675_d();
            worldRenderer.func_181662_b((double)minX, (double)maxY, 0.0).func_187315_a((double)u1, (double)v2).func_181666_a(r, g, b, 1.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
            textureManager.func_110577_a(TextureMap.field_110575_b);
            textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
            GL11.glDisable((int)2929);
            if (button != null && renderOverlays) {
                button.update(x, y, fluidStack, gui);
            }
        }
    }

    public static void renderItemTooltip(GuiInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my) {
        GlStateManager.func_179094_E();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && itemStack != null) {
            gui.func_146285_a(itemStack, mx, my);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    public static void renderFluidTooltip(GuiInfoBook gui, int x, int y, FluidStack fluidStack, int mx, int my) {
        GlStateManager.func_179094_E();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && fluidStack != null) {
            ArrayList lines = Lists.newArrayList();
            lines.add(fluidStack.getFluid().getRarity().field_77937_e + fluidStack.getLocalizedName());
            lines.add(TextFormatting.GRAY.toString() + fluidStack.amount + " mB");
            gui.func_146283_a(lines, mx, my);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    @Override
    protected int getHeight() {
        return this.getHeightInner() + this.getAdditionalHeight();
    }

    protected abstract int getHeightInner();

    protected int getAdditionalHeight() {
        return 5;
    }

    @Override
    protected int getOffsetY() {
        return this.getAdditionalHeight();
    }

    protected abstract String getUnlocalizedTitle();

    @Override
    public final void drawElement(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = this.getAdditionalHeight();
        gui.drawOuterBorder(x - 1, y - 1 - yOffset, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(L10NHelpers.localize(this.getUnlocalizedTitle(), new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, gui.getTitleColor());
        this.drawElementInner(gui, x, y, width, height, page, mx, my);
    }

    @Override
    protected void postDrawElement(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        this.renderToolTips(gui, mx, my);
    }

    protected abstract void drawElementInner(GuiInfoBook var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected void renderToolTips(GuiInfoBook gui, int mx, int my) {
        for (AdvancedButton renderItemHolder : this.renderItemHolders.values()) {
            renderItemHolder.renderTooltip(mx, my);
        }
    }

    @Override
    public void preBakeElement(InfoSection infoSection) {
        this.renderItemHolders.clear();
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        infoSection.addAdvancedButtons(this.getPage(), this.renderItemHolders.values());
    }

    public static class FluidButton
    extends ElementButton<FluidStack> {
        public FluidButton(IInfoBook infoBook) {
            super(infoBook);
        }

        @Override
        protected ExtendedConfig<?> getConfigFromElement(FluidStack element) {
            return ConfigHandler.getConfigFromFluid(element.getFluid());
        }

        @Override
        public void renderTooltip(int mx, int my) {
            RecipeAppendix.renderFluidTooltip(this.gui, this.field_146128_h, this.field_146129_i, (FluidStack)this.getElement(), mx, my);
        }
    }

    public static class ItemButton
    extends ElementButton<ItemStack> {
        public ItemButton(IInfoBook infoBook) {
            super(infoBook);
        }

        @Override
        public void update(int x, int y, ItemStack element, GuiInfoBook gui) {
            super.update(x, y, element.func_190926_b() ? null : element, gui);
        }

        @Override
        public void renderTooltip(int mx, int my) {
            RecipeAppendix.renderItemTooltip(this.gui, this.field_146128_h, this.field_146129_i, (ItemStack)this.getElement(), mx, my);
        }

        @Override
        protected ExtendedConfig<?> getConfigFromElement(ItemStack element) {
            return ConfigHandler.getConfigFromItem(element.func_77973_b());
        }
    }

    public static abstract class ElementButton<E>
    extends AdvancedButton {
        private final IInfoBook infoBook;
        private E element;

        public ElementButton(IInfoBook infoBook) {
            this.infoBook = infoBook;
        }

        public E getElement() {
            return this.element;
        }

        public void update(int x, int y, E element, GuiInfoBook gui) {
            Pair<InfoSection, Integer> pair;
            ExtendedConfig<?> config;
            this.element = element;
            InfoSection target = null;
            if (this.element != null && (config = this.getConfigFromElement(element)) != null && (pair = this.infoBook.getConfigLinks().get(config.getFullUnlocalizedName())) != null) {
                target = (InfoSection)pair.getLeft();
            }
            super.update(x, y, "empty", target, gui);
        }

        protected abstract ExtendedConfig<?> getConfigFromElement(E var1);

        @Override
        public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
            if (this.isVisible() && this.isHover(mouseX, mouseY)) {
                this.gui.drawOuterBorder(this.field_146128_h, this.field_146129_i, 16, 16, 0.392f, 0.392f, 0.6f, 0.9f);
            }
        }

        @Override
        public boolean isVisible() {
            return super.isVisible() && this.element != null;
        }
    }
}

