/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.capabilities;

import java.util.Objects;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;

public class DefaultSidedCapabilityProvider<T>
implements ICapabilityProvider {
    private final EnumFacingMap<Pair<Capability<T>, T>> capabilities;

    public DefaultSidedCapabilityProvider(EnumFacingMap<Pair<Capability<T>, T>> capabilities) {
        this.capabilities = Objects.requireNonNull(capabilities);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.capabilities.containsKey(facing) && ((Pair)this.capabilities.get(facing)).getKey() == capability;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)((Pair)this.capabilities.get(facing)).getValue();
        }
        return null;
    }

    public static <T, H extends ISidedCapabilityConstructor<T>> EnumFacingMap<Pair<Capability<T>, T>> forAllSides(Capability<T> capabilityType, H constructor) {
        return EnumFacingMap.forAllValues(Pair.of(capabilityType, constructor.createForSide(EnumFacing.DOWN)), Pair.of(capabilityType, constructor.createForSide(EnumFacing.UP)), Pair.of(capabilityType, constructor.createForSide(EnumFacing.NORTH)), Pair.of(capabilityType, constructor.createForSide(EnumFacing.SOUTH)), Pair.of(capabilityType, constructor.createForSide(EnumFacing.WEST)), Pair.of(capabilityType, constructor.createForSide(EnumFacing.EAST)));
    }

    public static interface ISidedCapabilityConstructor<T> {
        public T createForSide(EnumFacing var1);
    }
}

