/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.world;

import com.google.common.collect.Maps;
import java.util.Map;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.persist.world.WorldStorage;

public class GlobalCounters
extends WorldStorage {
    @NBTPersist
    private Map<String, Integer> counters = Maps.newHashMap();

    public GlobalCounters(ModBase mod) {
        super(mod);
    }

    public synchronized int getNext(String key) {
        int next = 0;
        if (this.counters.containsKey(key)) {
            next = this.counters.get(key);
        }
        this.counters.put(key, next + 1);
        return next;
    }

    @Override
    public void reset() {
        this.counters.clear();
    }

    @Override
    protected String getDataId() {
        return "GlobalCounterData";
    }
}

