/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tracking;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.modcompat.versionchecker.VersionCheckerModCompat;
import org.cyclops.cyclopscore.tracking.IModVersion;

public class Versions {
    private static final List<Triple<ModBase, IModVersion, String>> versionMods = Lists.newLinkedList();
    private static volatile boolean checked = false;
    private static volatile boolean allDone = false;
    private static volatile boolean displayed = false;

    public static synchronized void registerMod(ModBase mod, IModVersion modVersion, String versionUrl) {
        versionMods.add((Triple<ModBase, IModVersion, String>)Triple.of((Object)mod, (Object)modVersion, (Object)versionUrl));
    }

    protected static synchronized List<Triple<ModBase, IModVersion, String>> getVersionMods() {
        return Lists.newArrayList(versionMods);
    }

    public static void checkAll() {
        if (!checked) {
            checked = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    List<Triple<ModBase, IModVersion, String>> versionMods = Versions.getVersionMods();
                    for (Triple<ModBase, IModVersion, String> triple : versionMods) {
                        try {
                            URL url = new URL((String)triple.getRight());
                            String data = IOUtils.toString((URL)url);
                            String[] lines = data.split("\\r?\\n");
                            if (lines.length < 3) {
                                ((ModBase)triple.getLeft()).log(Level.WARN, "Retrieved invalid version data.");
                                continue;
                            }
                            String version = lines[0];
                            String info = lines[1];
                            String updateUrl = lines[2];
                            Versions.setVersionInfo((ModBase)triple.getLeft(), (IModVersion)triple.getMiddle(), version, info, updateUrl);
                            if (((IModVersion)triple.getMiddle()).needsUpdate()) {
                                VersionCheckerModCompat.sendIMCOutdatedMessage((ModBase)triple.getLeft(), (IModVersion)triple.getMiddle());
                            }
                            if (((IModVersion)triple.getMiddle()).needsUpdate()) {
                                ((ModBase)triple.getLeft()).log(Level.INFO, String.format("%s is outdated, version %s can be found at %s.", ((ModBase)triple.getLeft()).getModName(), version, updateUrl));
                                continue;
                            }
                            ((ModBase)triple.getLeft()).log(Level.INFO, String.format("%s is up-to-date!", ((ModBase)triple.getLeft()).getModName()));
                        }
                        catch (IOException e) {
                            ((ModBase)triple.getLeft()).log(Level.WARN, "Could not get version info: " + e.toString());
                            Versions.setVersionInfo((ModBase)triple.getLeft(), (IModVersion)triple.getMiddle(), null, null, null);
                        }
                    }
                    allDone = true;
                }
            }).run();
        }
    }

    public static void setVersionInfo(ModBase mod, IModVersion modVersion, String version, String info, String updateUrl) {
        modVersion.setVersionInfo(version, info, updateUrl);
        if (version != null && info != null && updateUrl != null) {
            Versions.setForgeVersionInfo(mod, modVersion, version, info, updateUrl);
        }
    }

    public static void setForgeVersionInfo(ModBase mod, IModVersion modVersion, String version, String info, String updateUrl) {
        try {
            Field resultsField = ForgeVersion.class.getDeclaredField("results");
            resultsField.setAccessible(true);
            Map results = (Map)resultsField.get(null);
            Constructor constructor = ForgeVersion.CheckResult.class.getDeclaredConstructor(ForgeVersion.Status.class, ComparableVersion.class, Map.class, String.class);
            constructor.setAccessible(true);
            ForgeVersion.Status status = modVersion.needsUpdate() ? ForgeVersion.Status.OUTDATED : ForgeVersion.Status.UP_TO_DATE;
            ComparableVersion comparableVersion = new ComparableVersion(version);
            ForgeVersion.CheckResult checkResult = (ForgeVersion.CheckResult)constructor.newInstance(status, comparableVersion, ImmutableMap.of((Object)comparableVersion, (Object)info), updateUrl);
            ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(mod.getModId());
            results.put(modContainer, checkResult);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            mod.log(Level.ERROR, String.format("Failed to set Forge version information for %s-%s.", mod.getModName(), version));
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public synchronized void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && allDone && !displayed) {
            List<Triple<ModBase, IModVersion, String>> versionMods = Versions.getVersionMods();
            for (Triple<ModBase, IModVersion, String> triple : versionMods) {
                if (!((IModVersion)triple.getMiddle()).needsUpdate()) continue;
                EntityPlayer player = event.player;
                TextComponentString chat = new TextComponentString("");
                Style modNameStyle = new Style();
                modNameStyle.func_150238_a(TextFormatting.AQUA);
                Style versionStyle = new Style();
                versionStyle.func_150238_a(TextFormatting.AQUA);
                Style downloadStyle = new Style();
                downloadStyle.func_150238_a(TextFormatting.BLUE);
                String currentVersion = "1.11.2-" + ((ModBase)triple.getLeft()).getReferenceValue(ModBase.REFKEY_MOD_VERSION);
                String newVersion = "1.11.2-" + ((IModVersion)triple.getMiddle()).getVersion();
                ITextComponent versionTransition = new TextComponentString(String.format("%s -> %s", currentVersion, newVersion)).func_150255_a(versionStyle);
                modNameStyle.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, versionTransition));
                ITextComponent modNameComponent = new TextComponentString(String.format("[%s]", ((ModBase)triple.getLeft()).getModName())).func_150255_a(modNameStyle);
                ITextComponent downloadComponent = new TextComponentString(String.format("[%s]", L10NHelpers.localize("general.cyclopscore.version.download", new Object[0]))).func_150255_a(downloadStyle);
                downloadStyle.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("general.cyclopscore.version.clickToDownload", new Object[0])));
                downloadStyle.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, ((IModVersion)triple.getMiddle()).getUpdateUrl()));
                chat.func_150257_a(modNameComponent);
                chat.func_150258_a(" ");
                chat.func_150257_a(new TextComponentTranslation("general.cyclopscore.version.updateAvailable", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
                chat.func_150258_a(String.format(": %s ", ((IModVersion)triple.getMiddle()).getVersion()));
                chat.func_150257_a(downloadComponent);
                try {
                    player.func_145747_a((ITextComponent)chat);
                    chat = new TextComponentString("");
                    chat.func_150257_a(modNameComponent);
                    chat.func_150258_a(TextFormatting.WHITE + " ");
                    chat.func_150258_a(((IModVersion)triple.getMiddle()).getInfo());
                    player.func_145747_a((ITextComponent)chat);
                }
                catch (NullPointerException e) {
                    return;
                }
            }
            displayed = true;
            try {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

