/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.GuiHelpers;

@SideOnly(value=Side.CLIENT)
public class RenderItemExtendedSlotCount
extends RenderItem {
    private static RenderItemExtendedSlotCount instance;
    private final RenderItem renderItemInner;

    protected RenderItemExtendedSlotCount(Minecraft mc) {
        this(mc.func_110434_K(), mc.func_175599_af().func_175037_a().func_178083_a(), mc.getItemColors(), mc.func_175599_af());
    }

    protected RenderItemExtendedSlotCount(TextureManager textureManager, ModelManager modelManager, ItemColors itemColors, RenderItem renderItemInner) {
        super(Objects.requireNonNull(textureManager), Objects.requireNonNull(modelManager), Objects.requireNonNull(itemColors));
        this.renderItemInner = renderItemInner;
    }

    public static RenderItemExtendedSlotCount getInstance() {
        return instance;
    }

    public static void initialize() {
        instance = new RenderItemExtendedSlotCount(Minecraft.func_71410_x());
    }

    public static void drawSlotText(FontRenderer fontRenderer, String string, int x, int y) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        float scale = 0.5f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int width = fontRenderer.func_78256_a(string);
        fontRenderer.func_175063_a(string, (float)(x + 16) / scale - (float)width, (float)(y + 12) / scale, 0xFFFFFF);
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
    }

    public void func_180453_a(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text) {
        if (!stack.func_190926_b()) {
            EntityPlayerSP entityplayersp;
            float f3;
            if (stack.func_190916_E() != 1 || text != null) {
                RenderItemExtendedSlotCount.drawSlotText(fr, text == null ? GuiHelpers.quantityToScaledString(stack.func_190916_E()) : text, xPosition, yPosition);
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179090_x();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int rgbfordisplay = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = rgbfordisplay;
                this.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                this.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
                GlStateManager.func_179098_w();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            float f = f3 = (entityplayersp = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : entityplayersp.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179090_x();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                this.func_181565_a(bufferbuilder1, xPosition, yPosition + MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                GlStateManager.func_179098_w();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
        }
    }

    public ItemModelMesher func_175037_a() {
        return this.renderItemInner.func_175037_a();
    }

    public boolean func_175050_a(ItemStack stack) {
        return this.renderItemInner.func_175050_a(stack);
    }

    public IBakedModel func_184393_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entitylivingbaseIn) {
        return this.renderItemInner.func_184393_a(stack, worldIn, entitylivingbaseIn);
    }

    protected void func_175048_a(Item itm, int subType, String identifier) {
    }

    protected void func_175029_a(Block blk, int subType, String identifier) {
    }
}

