/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.fluid;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTank;

public class Tank
extends FluidTank {
    private final String name;

    public Tank(int capacity, TileEntity tile) {
        super(capacity);
        this.name = "tank";
        this.tile = tile;
    }

    @Deprecated
    public Tank(String name, int capacity, TileEntity tile) {
        super(capacity);
        this.name = name;
        this.tile = tile;
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().amount <= 0;
    }

    public boolean isFull() {
        return this.getFluid() != null && this.getFluid().amount >= this.getCapacity();
    }

    public Fluid getFluidType() {
        return this.getFluid() != null ? this.getFluid().getFluid() : null;
    }

    protected boolean replaceInnerFluid() {
        return true;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound tankData = new NBTTagCompound();
        if (this.replaceInnerFluid()) {
            super.writeToNBT(tankData);
        }
        this.writeTankToNBT(tankData);
        nbt.func_74782_a(this.name, (NBTBase)tankData);
        return nbt;
    }

    public FluidTank readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(this.name)) {
            NBTTagCompound tankData = nbt.func_74775_l(this.name);
            if (this.replaceInnerFluid()) {
                if (tankData.func_74764_b("Empty")) {
                    this.setFluid(null);
                }
                super.readFromNBT(tankData);
            }
            this.readTankFromNBT(tankData);
        }
        return this;
    }

    public void writeTankToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("capacity", this.getCapacity());
    }

    public void readTankFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("capacity")) {
            this.setCapacity(nbt.func_74762_e("capacity"));
        }
    }

    public String getName() {
        return this.name;
    }
}

