/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.TRSRTransformation;

public final class ModelHelpers {
    public static final TRSRTransformation THIRD_PERSON_RIGHT_HAND = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(70.0f, 45.0f, 0.0f)), new Vector3f(0.375f, 0.375f, 0.375f), null));
    public static final TRSRTransformation THIRD_PERSON_LEFT_HAND = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(70.0f, 45.0f, 0.0f)), new Vector3f(0.375f, 0.375f, 0.375f), null));
    public static final TRSRTransformation FIRST_PERSON_RIGHT_HAND = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 45.0f, 0.0f)), new Vector3f(0.4f, 0.4f, 0.4f), null));
    public static final TRSRTransformation FIRST_PERSON_LEFT_HAND = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 225.0f, 0.0f)), new Vector3f(0.4f, 0.4f, 0.4f), null));
    public static final TRSRTransformation GROUND = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 0.0f, 0.0f)), new Vector3f(0.375f, 0.375f, 0.375f), null));
    public static final TRSRTransformation FIXED = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 0.0f, 0.0f)), new Vector3f(0.5f, 0.5f, 0.5f), null));
    public static final TRSRTransformation GUI = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(30.0f, 225.0f, 0.0f)), new Vector3f(0.625f, 0.625f, 0.625f), null));
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> DEFAULT_PERSPECTIVE_TRANSFORMS = new ImmutableMap.Builder().put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)THIRD_PERSON_RIGHT_HAND).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)THIRD_PERSON_LEFT_HAND).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)FIRST_PERSON_RIGHT_HAND).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)FIRST_PERSON_LEFT_HAND).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)GROUND).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)FIXED).put((Object)ItemCameraTransforms.TransformType.GUI, (Object)GUI).build();
    public static final TRSRTransformation THIRD_PERSON_RIGHT_HAND_ITEM = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 0.0f, 0.0f)), new Vector3f(0.55f, 0.55f, 0.55f), null));
    public static final TRSRTransformation THIRD_PERSON_LEFT_HAND_ITEM = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 0.0f, 0.0f)), new Vector3f(0.55f, 0.55f, 0.55f), null));
    public static final TRSRTransformation FIRST_PERSON_RIGHT_HAND_ITEM = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, -90.0f, 25.0f)), new Vector3f(0.68f, 0.68f, 0.68f), null));
    public static final TRSRTransformation FIRST_PERSON_LEFT_HAND_ITEM = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, -90.0f, 25.0f)), new Vector3f(0.68f, 0.68f, 0.68f), null));
    public static final TRSRTransformation GROUND_ITEM = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 0.0f, 0.0f)), new Vector3f(0.5f, 0.5f, 0.5f), null));
    public static final TRSRTransformation FIXED_ITEM = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 0.0f, 0.0f)), new Vector3f(1.0f, 1.0f, 1.0f), null));
    public static final TRSRTransformation GUI_ITEM = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 0.0f, 0.0f)), new Vector3f(1.0f, 1.0f, 1.0f), null));
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> DEFAULT_PERSPECTIVE_TRANSFORMS_ITEM = new ImmutableMap.Builder().put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)THIRD_PERSON_RIGHT_HAND_ITEM).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)THIRD_PERSON_LEFT_HAND_ITEM).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)FIRST_PERSON_RIGHT_HAND_ITEM).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)FIRST_PERSON_LEFT_HAND_ITEM).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)GROUND_ITEM).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)FIXED_ITEM).put((Object)ItemCameraTransforms.TransformType.GUI, (Object)GUI_ITEM).build();
    public static final Map<EnumFacing, List<BakedQuad>> EMPTY_FACE_QUADS = Maps.newHashMap();

    public static ModelBlock loadModelBlock(ResourceLocation modelLocation) throws IOException {
        IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a() + ".json"));
        InputStreamReader reader = new InputStreamReader(resource.func_110527_b(), Charsets.UTF_8);
        return ModelBlock.func_178307_a((Reader)reader);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> modifyDefaultTransforms(Map<ItemCameraTransforms.TransformType, TRSRTransformation> overrides) {
        HashMap transforms = Maps.newHashMap(DEFAULT_PERSPECTIVE_TRANSFORMS);
        transforms.putAll(overrides);
        return new ImmutableMap.Builder().putAll((Map)transforms).build();
    }

    static {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            EMPTY_FACE_QUADS.put(facing, Collections.emptyList());
        }
    }
}

