/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class NBTSimpleInventoryItemHeld
extends SimpleInventory {
    public static final String NBT_TAG_ROOT = "NBTSimpleInventory";
    protected EntityPlayer player;
    protected int itemIndex;
    protected EnumHand hand;

    public NBTSimpleInventoryItemHeld(EntityPlayer player, int itemIndex, int size, int stackLimit) {
        this(player, itemIndex, EnumHand.MAIN_HAND, size, stackLimit);
    }

    public NBTSimpleInventoryItemHeld(EntityPlayer player, int itemIndex, EnumHand hand, int size, int stackLimit) {
        super(size, NBT_TAG_ROOT, stackLimit);
        this.player = player;
        this.itemIndex = itemIndex;
        this.hand = hand;
        InventoryHelpers.validateNBTStorage(this, InventoryHelpers.getItemFromIndex(player, itemIndex, hand), NBT_TAG_ROOT);
    }

    @Override
    public void func_70296_d() {
        ItemStack itemStack = InventoryHelpers.getItemFromIndex(this.player, this.itemIndex, this.hand);
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        this.writeToNBT(tag, NBT_TAG_ROOT);
        InventoryHelpers.getItemFromIndex(this.player, this.itemIndex, this.hand).func_77982_d(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound data, String tagName) {
        InventoryHelpers.readFromNBT(this, data, tagName);
    }

    @Override
    public void writeToNBT(NBTTagCompound data, String tagName) {
        InventoryHelpers.writeToNBT(this, data, tagName);
    }
}

