/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.capabilities;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;

public class CapabilityConstructorRegistry {
    private final Map<Class<? extends TileEntity>, List<ICapabilityConstructor<?, ? extends TileEntity, ? extends TileEntity>>> capabilityConstructorsTile = Maps.newIdentityHashMap();
    private final Map<Class<? extends Entity>, List<ICapabilityConstructor<?, ? extends Entity, ? extends Entity>>> capabilityConstructorsEntity = Maps.newIdentityHashMap();
    private final Map<Class<? extends Item>, List<ICapabilityConstructor<?, ? extends Item, ? extends ItemStack>>> capabilityConstructorsItem = Maps.newIdentityHashMap();
    private Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> capabilityConstructorsTileSuper = Sets.newHashSet();
    private Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> capabilityConstructorsEntitySuper = Sets.newHashSet();
    private Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> capabilityConstructorsItemSuper = Sets.newHashSet();
    protected final ModBase mod;
    protected boolean baked = false;
    protected boolean registeredTileEventListener = false;
    protected boolean registeredEntityEventListener = false;
    protected boolean registeredItemStackEventListener = false;

    public CapabilityConstructorRegistry(ModBase mod) {
        this.mod = mod;
    }

    protected ModBase getMod() {
        return this.mod;
    }

    protected void checkNotBaked() {
        if (this.baked) {
            throw new IllegalStateException("Please register capabilities before pre-init.");
        }
    }

    public <T extends TileEntity> void registerTile(Class<T> clazz, ICapabilityConstructor<?, T, T> constructor) {
        this.checkNotBaked();
        ArrayList constructors = this.capabilityConstructorsTile.get(clazz);
        if (constructors == null) {
            constructors = Lists.newArrayList();
            this.capabilityConstructorsTile.put(clazz, constructors);
        }
        constructors.add(constructor);
        if (!this.registeredTileEventListener) {
            this.registeredTileEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new TileEventListener());
        }
    }

    public <T extends Entity> void registerEntity(Class<T> clazz, ICapabilityConstructor<?, T, T> constructor) {
        this.checkNotBaked();
        ArrayList constructors = this.capabilityConstructorsEntity.get(clazz);
        if (constructors == null) {
            constructors = Lists.newArrayList();
            this.capabilityConstructorsEntity.put(clazz, constructors);
        }
        constructors.add(constructor);
        if (!this.registeredEntityEventListener) {
            this.registeredEntityEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new EntityEventListener());
        }
    }

    public <T extends Item> void registerItem(Class<T> clazz, ICapabilityConstructor<?, T, ItemStack> constructor) {
        this.checkNotBaked();
        ArrayList constructors = this.capabilityConstructorsItem.get(clazz);
        if (constructors == null) {
            constructors = Lists.newArrayList();
            this.capabilityConstructorsItem.put(clazz, constructors);
        }
        constructors.add(constructor);
        if (!this.registeredItemStackEventListener) {
            this.registeredItemStackEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new ItemStackEventListener());
        }
    }

    public <K, V> void registerInheritableTile(Class<K> clazz, ICapabilityConstructor<?, V, V> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsTileSuper.add(Pair.of(clazz, constructor));
        if (!this.registeredTileEventListener) {
            this.registeredTileEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new TileEventListener());
        }
    }

    public <K, V> void registerInheritableEntity(Class<K> clazz, ICapabilityConstructor<?, V, V> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsEntitySuper.add(Pair.of(clazz, constructor));
        if (!this.registeredEntityEventListener) {
            this.registeredEntityEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new EntityEventListener());
        }
    }

    public <T> void registerInheritableItem(Class<T> clazz, ICapabilityConstructor<?, ?, ? extends ItemStack> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsItemSuper.add(Pair.of(clazz, constructor));
        if (!this.registeredItemStackEventListener) {
            this.registeredItemStackEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new ItemStackEventListener());
        }
    }

    protected <K, KE, H, HE> ICapabilityProvider createProvider(KE hostType, HE host, ICapabilityConstructor<?, K, H> capabilityConstructor) {
        return capabilityConstructor.createProvider(hostType, host);
    }

    protected <T> void onLoad(Map<Class<? extends T>, List<ICapabilityConstructor<?, ? extends T, ? extends T>>> allConstructors, Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> allInheritableConstructors, T object, AttachCapabilitiesEvent<?> event, Class<? extends T> baseClass) {
        this.onLoad(allConstructors, allInheritableConstructors, object, object, event, baseClass);
    }

    protected <K, V> void onLoad(Map<Class<? extends K>, List<ICapabilityConstructor<?, ? extends K, ? extends V>>> allConstructors, Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> allInheritableConstructors, K keyObject, V valueObject, AttachCapabilitiesEvent<?> event, Class<? extends K> baseClass) {
        Collection constructors;
        boolean initialized;
        boolean bl = initialized = this.baked || Helpers.isMinecraftInitialized();
        if (!this.baked && Helpers.isMinecraftInitialized()) {
            this.bake();
        }
        if ((constructors = (Collection)allConstructors.get(keyObject.getClass())) != null) {
            for (ICapabilityConstructor iCapabilityConstructor : constructors) {
                if (!initialized && iCapabilityConstructor.getCapability() == null) continue;
                this.addLoadedCapabilityProvider(event, keyObject, valueObject, iCapabilityConstructor);
            }
        }
        for (Pair pair : allInheritableConstructors) {
            if (!initialized && ((ICapabilityConstructor)pair.getRight()).getCapability() == null || keyObject != baseClass && pair.getLeft() != keyObject && !((Class)pair.getLeft()).isInstance(keyObject)) continue;
            this.addLoadedCapabilityProvider(event, keyObject, valueObject, (ICapabilityConstructor)pair.getRight());
        }
    }

    protected <K, V> void addLoadedCapabilityProvider(AttachCapabilitiesEvent<?> event, K keyObject, V valueObject, ICapabilityConstructor<?, ?, ?> constructor) {
        ICapabilityProvider provider = this.createProvider(keyObject, valueObject, constructor);
        if (provider != null) {
            ResourceLocation id = new ResourceLocation(this.getMod().getModId(), constructor.getCapability().getName());
            if (!event.getCapabilities().containsKey(id)) {
                event.addCapability(id, provider);
            } else {
                this.getMod().getLoggerHelper().log(Level.DEBUG, "Duplicate capability registration of " + id + " in " + keyObject);
            }
        }
    }

    protected <K, V> void removeNullCapabilities(Map<Class<? extends K>, List<ICapabilityConstructor<?, ? extends K, ? extends V>>> allConstructors, Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> allInheritableConstructors) {
        List<ICapabilityConstructor<?, K, V>> constructors;
        HashMultimap toRemoveMap = HashMultimap.create();
        for (Class<K> clazz : allConstructors.keySet()) {
            constructors = allConstructors.get(clazz);
            for (ICapabilityConstructor iCapabilityConstructor : constructors) {
                if (iCapabilityConstructor.getCapability() != null) continue;
                toRemoveMap.put(clazz, (Object)iCapabilityConstructor);
            }
        }
        for (Map.Entry entry : toRemoveMap.entries()) {
            constructors = allConstructors.get(entry.getKey());
            constructors.remove(entry.getValue());
        }
        ArrayList toRemoveInheritableList = Lists.newArrayList();
        for (Pair<Class<?>, ICapabilityConstructor<?, ?, ?>> constructorEntry : allInheritableConstructors) {
            if (((ICapabilityConstructor)constructorEntry.getRight()).getCapability() != null) continue;
            toRemoveInheritableList.add(constructorEntry);
        }
        for (Pair toRemove : toRemoveInheritableList) {
            allInheritableConstructors.remove(toRemove);
        }
    }

    public void bake() {
        this.baked = true;
        this.removeNullCapabilities(this.capabilityConstructorsTile, this.capabilityConstructorsTileSuper);
        this.removeNullCapabilities(this.capabilityConstructorsEntity, this.capabilityConstructorsEntitySuper);
        this.removeNullCapabilities(this.capabilityConstructorsItem, this.capabilityConstructorsItemSuper);
        this.capabilityConstructorsTileSuper = ImmutableList.copyOf(this.capabilityConstructorsTileSuper);
        this.capabilityConstructorsEntitySuper = ImmutableList.copyOf(this.capabilityConstructorsEntitySuper);
        this.capabilityConstructorsItemSuper = ImmutableList.copyOf(this.capabilityConstructorsItemSuper);
    }

    public class ItemStackEventListener {
        @SubscribeEvent
        public void onItemStackLoad(AttachCapabilitiesEvent<ItemStack> event) {
            if (!((ItemStack)event.getObject()).func_190926_b()) {
                CapabilityConstructorRegistry.this.onLoad(CapabilityConstructorRegistry.this.capabilityConstructorsItem, CapabilityConstructorRegistry.this.capabilityConstructorsItemSuper, ((ItemStack)event.getObject()).func_77973_b(), event.getObject(), event, Item.class);
            }
        }
    }

    public class EntityEventListener {
        @SubscribeEvent
        public void onEntityLoad(AttachCapabilitiesEvent<Entity> event) {
            CapabilityConstructorRegistry.this.onLoad(CapabilityConstructorRegistry.this.capabilityConstructorsEntity, CapabilityConstructorRegistry.this.capabilityConstructorsEntitySuper, event.getObject(), event, Entity.class);
        }
    }

    public class TileEventListener {
        @SubscribeEvent
        public void onTileLoad(AttachCapabilitiesEvent<TileEntity> event) {
            CapabilityConstructorRegistry.this.onLoad(CapabilityConstructorRegistry.this.capabilityConstructorsTile, CapabilityConstructorRegistry.this.capabilityConstructorsTileSuper, event.getObject(), event, TileEntity.class);
        }
    }
}

